/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.heater;

import com.mrh0.createaddition.blocks.heater.HeaterBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricTileEntity;
import com.mrh0.createaddition.item.Multimeter;
import com.mrh0.createaddition.mixin.AbstractFurnaceMixin;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import java.util.List;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class HeaterTileEntity
extends BaseElectricTileEntity
implements IHaveGoggleInformation {
    public AbstractFurnaceTileEntity cache;
    private boolean isFurnaceEngine = false;
    public static final int CONSUMPTION = (Integer)Config.HEATER_NORMAL_CONSUMPTION.get();
    public static final int CONSUMPTION_ENGINE = (Integer)Config.HEATER_FURNACE_ENGINE_CONSUMPTION.get();
    public static final boolean ALLOW_ENGINE = (Boolean)Config.HEATER_FURNACE_ENGINE_ENABLED.get();
    private boolean litState = false;
    private static final int MAX_IN = (Integer)Config.HEATER_MAX_INPUT.get();
    private static final int MAX_OUT = 0;
    private static final int CAPACITY = (Integer)Config.HEATER_CAPACITY.get();

    public HeaterTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, CAPACITY, MAX_IN, 0);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side == ((Direction)this.func_195044_w().func_177229_b((Property)HeaterBlock.FACING)).func_176734_d();
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.cache == null) {
            return;
        }
        if (this.cache.func_145837_r()) {
            this.cache = null;
        }
        if (this.cache == null) {
            return;
        }
        IIntArray data = ((AbstractFurnaceMixin)this.cache).getDataAccess();
        if (this.hasEnoughEnergy()) {
            data.func_221477_a(0, Math.min(200, data.func_221476_a(0) + 2));
            if (!this.litState) {
                this.updateState(true);
            }
            this.litState = true;
        } else if (this.litState && data.func_221476_a(0) < 1) {
            this.updateState(false);
            this.litState = false;
        }
        if (this.hasEnoughEnergy()) {
            this.energy.internalConsumeEnergy(this.getConsumption());
        }
        this.isFurnaceEngine = this.hasFurnaceEngine();
    }

    public void refreshCache() {
        Direction d = (Direction)this.func_195044_w().func_177229_b((Property)HeaterBlock.FACING);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
        this.cache = te instanceof AbstractFurnaceTileEntity ? (AbstractFurnaceTileEntity)te : null;
        this.isFurnaceEngine = this.hasFurnaceEngine();
    }

    public boolean hasEnoughEnergy() {
        if (!ALLOW_ENGINE && this.isFurnaceEngine) {
            return false;
        }
        return this.energy.getEnergyStored() > (this.isFurnaceEngine ? CONSUMPTION_ENGINE : CONSUMPTION);
    }

    public boolean hasFurnaceEngine() {
        Direction dir = (Direction)this.func_195044_w().func_177229_b((Property)HeaterBlock.FACING);
        BlockPos origin = this.field_174879_c.func_177972_a(dir);
        for (Direction d : Direction.values()) {
            if (this.field_145850_b.func_180495_p(origin.func_177972_a(d)).func_177230_c() != AllBlocks.FURNACE_ENGINE.get()) continue;
            return true;
        }
        return false;
    }

    public int getConsumption() {
        return this.isFurnaceEngine ? CONSUMPTION_ENGINE : CONSUMPTION;
    }

    public void lazyTick() {
        super.lazyTick();
    }

    public void updateState(boolean lit) {
        Direction d = (Direction)this.func_195044_w().func_177229_b((Property)HeaterBlock.FACING);
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(d));
        if (state.func_177230_c() instanceof AbstractFurnaceBlock && (Boolean)state.func_177229_b((Property)AbstractFurnaceBlock.field_220091_b) != lit) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177972_a(d), (BlockState)state.func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(lit)));
        }
        this.causeBlockUpdate();
    }

    @Override
    public void firstTick() {
        super.firstTick();
        this.refreshCache();
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("block.createaddition.heater.info").func_240699_a_(TextFormatting.WHITE)));
        if (this.isFurnaceEngine && !ALLOW_ENGINE) {
            tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("block.createaddition.heater.engine_heating_disabled").func_240699_a_(TextFormatting.RED)));
        }
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.consumption").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new StringTextComponent(" " + Multimeter.format(this.hasEnoughEnergy() ? this.getConsumption() : 0) + "fe/t ")).func_240699_a_(TextFormatting.AQUA));
        return true;
    }
}

