/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.rolling_mill;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.recipe.rolling.RollingRecipe;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class RollingMillTileEntity
extends KineticTileEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public LazyOptional<IItemHandler> capability = LazyOptional.of(() -> new RollingMillInventoryHandler());
    public int timer;
    private RollingRecipe lastRecipe;
    private static final int STRESS = (Integer)Config.ROLLING_MILL_STRESS.get();
    private static final int DURATION = (Integer)Config.ROLLING_MILL_PROCESSING_DURATION.get();

    public RollingMillTileEntity(TileEntityType<? extends RollingMillTileEntity> type) {
        super(type);
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).func_190916_E() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.field_145850_b.field_72995_K) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).func_190926_b()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_145850_b)) {
            Optional<RollingRecipe> recipe = this.find(inventoryIn, this.field_145850_b);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = recipe.get();
                this.timer = RollingMillTileEntity.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = RollingMillTileEntity.getProcessingDuration();
        this.sendData();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.capability.invalidate();
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.field_145850_b)) {
            Optional<RollingRecipe> recipe = this.find(inventoryIn, this.field_145850_b);
            if (!recipe.isPresent()) {
                return;
            }
            this.lastRecipe = recipe.get();
        }
        ItemStack result = this.lastRecipe.assemble(inventoryIn).func_77946_l();
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.func_190918_g(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.sendData();
        this.func_70296_d();
    }

    public void spawnParticles() {
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.func_190926_b()) {
            return;
        }
        ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, stackInSlot);
        float angle = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        Vector3d offset = new Vector3d(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vector3d)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vector3d target = VecHelper.rotate((Vector3d)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vector3d center = offset.func_178787_e(VecHelper.getCenterOf((Vector3i)this.field_174879_c));
        target = VecHelper.offsetRandomly((Vector3d)target.func_178788_d(offset), (Random)this.field_145850_b.field_73012_v, (float)0.0078125f);
        this.field_145850_b.func_195594_a((IParticleData)data, center.field_72450_a, center.field_72448_b, center.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c);
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74768_a("Timer", this.timer);
        compound.func_218657_a("InputInventory", (INBT)this.inputInv.serializeNBT());
        compound.func_218657_a("OutputInventory", (INBT)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.timer = compound.func_74762_e("Timer");
        this.inputInv.deserializeNBT(compound.func_74775_l("InputInventory"));
        this.outputInv.deserializeNBT(compound.func_74775_l("OutputInventory"));
        super.fromTag(state, compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return MathHelper.func_76125_a((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }

    private boolean canProcess(ItemStack stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandlerModifiable)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.field_145850_b)) {
            return true;
        }
        return this.find(inventoryIn, this.field_145850_b).isPresent();
    }

    public Optional<RollingRecipe> find(RecipeWrapper inv, World world) {
        return world.func_199532_z().func_215371_a(RollingRecipe.TYPE, (IInventory)inv, world);
    }

    public static int getProcessingDuration() {
        return DURATION;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)STRESS;
        return impact;
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    private class RollingMillInventoryHandler
    extends CombinedInvWrapper {
        public RollingMillInventoryHandler() {
            super(new IItemHandlerModifiable[]{RollingMillTileEntity.this.inputInv, RollingMillTileEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (RollingMillTileEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return false;
            }
            return RollingMillTileEntity.this.canProcess(stack) && super.isItemValid(slot, stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (RollingMillTileEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (RollingMillTileEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.field_190927_a;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

