/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public abstract class BaseElectricTileEntity
extends SmartTileEntity {
    protected final InternalEnergyStorage energy;
    protected LazyOptional<IEnergyStorage> lazyEnergy;
    private boolean firstTickState = true;
    protected final int CAPACITY;
    protected final int MAX_IN;
    protected final int MAX_OUT;
    private LazyOptional<IEnergyStorage> escacheUp = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheDown = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheNorth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheEast = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheSouth = LazyOptional.empty();
    private LazyOptional<IEnergyStorage> escacheWest = LazyOptional.empty();

    public BaseElectricTileEntity(TileEntityType<?> tileEntityTypeIn, int CAPACITY, int MAX_IN, int MAX_OUT) {
        super(tileEntityTypeIn);
        this.energy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
        this.CAPACITY = CAPACITY;
        this.MAX_IN = MAX_IN;
        this.MAX_OUT = MAX_OUT;
        this.lazyEnergy = LazyOptional.of(() -> this.energy);
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (this.isEnergyInput(side) || this.isEnergyOutput(side))) {
            return this.lazyEnergy.cast();
        }
        return super.getCapability(cap, side);
    }

    public abstract boolean isEnergyInput(Direction var1);

    public abstract boolean isEnergyOutput(Direction var1);

    public void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.energy.read(compound);
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyEnergy.invalidate();
    }

    @Deprecated
    public void outputTick(int max) {
        for (Direction side : Direction.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.energy.outputToSide(this.field_145850_b, this.field_174879_c, side, max);
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.firstTickState) {
            this.firstTick();
        }
        this.firstTickState = false;
    }

    public void firstTick() {
        this.updateCache();
    }

    public void updateCache() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        for (Direction side : Direction.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (te == null) {
                this.setCache(side, (LazyOptional<IEnergyStorage>)LazyOptional.empty());
                continue;
            }
            LazyOptional le = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
            this.setCache(side, (LazyOptional<IEnergyStorage>)le);
        }
    }

    public void setCache(Direction side, LazyOptional<IEnergyStorage> storage) {
        switch (side) {
            case DOWN: {
                this.escacheDown = storage;
                break;
            }
            case EAST: {
                this.escacheEast = storage;
                break;
            }
            case NORTH: {
                this.escacheNorth = storage;
                break;
            }
            case SOUTH: {
                this.escacheSouth = storage;
                break;
            }
            case UP: {
                this.escacheUp = storage;
                break;
            }
            case WEST: {
                this.escacheWest = storage;
            }
        }
    }

    public IEnergyStorage getCachedEnergy(Direction side) {
        switch (side) {
            case DOWN: {
                return (IEnergyStorage)this.escacheDown.orElse(null);
            }
            case EAST: {
                return (IEnergyStorage)this.escacheEast.orElse(null);
            }
            case NORTH: {
                return (IEnergyStorage)this.escacheNorth.orElse(null);
            }
            case SOUTH: {
                return (IEnergyStorage)this.escacheSouth.orElse(null);
            }
            case UP: {
                return (IEnergyStorage)this.escacheUp.orElse(null);
            }
            case WEST: {
                return (IEnergyStorage)this.escacheWest.orElse(null);
            }
        }
        return null;
    }
}

