/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.WireConnectResult;
import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.energy.network.EnergyNetwork;
import com.mrh0.createaddition.index.CAItems;
import com.mrh0.createaddition.item.WireSpool;
import com.mrh0.createaddition.util.Util;
import java.util.HashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public interface IWireNode {
    public static final int MAX_LENGTH = 12;

    public Vector3f getNodeOffset(int var1);

    default public int getNodeFromPos(Vector3d vector3d) {
        return 0;
    }

    default public int getNodeCount() {
        return 1;
    }

    public static boolean hasPos(CompoundNBT nbt, int node) {
        return nbt.func_74764_b("x" + node) && nbt.func_74764_b("y" + node) && nbt.func_74764_b("z" + node);
    }

    public static boolean hasNode(CompoundNBT nbt, int node) {
        return IWireNode.hasPos(nbt, node) && nbt.func_74764_b("type" + node);
    }

    default public int findOpenNode(int from, int to) {
        for (int i = from; i < to; ++i) {
            if (this.hasConnection(i)) continue;
            return i;
        }
        return -1;
    }

    default public CompoundNBT writeNode(CompoundNBT nbt, int node) {
        BlockPos pos = this.getNodePos(node);
        if (pos == null) {
            return nbt;
        }
        int index = this.getOtherNodeIndex(node);
        WireType type = this.getNodeType(node);
        nbt.func_74768_a("x" + node, pos.func_177958_n());
        nbt.func_74768_a("y" + node, pos.func_177956_o());
        nbt.func_74768_a("z" + node, pos.func_177952_p());
        nbt.func_74768_a("node" + node, index);
        nbt.func_74768_a("type" + node, type.getIndex());
        return nbt;
    }

    default public void readNode(CompoundNBT nbt, int node) {
        if (!IWireNode.hasNode(nbt, node)) {
            return;
        }
        BlockPos pos = new BlockPos(nbt.func_74762_e("x" + node), nbt.func_74762_e("y" + node), nbt.func_74762_e("z" + node));
        WireType type = WireType.fromIndex(nbt.func_74762_e("type" + node));
        int index = nbt.func_74762_e("node" + node);
        this.setNode(node, index, pos, type);
    }

    public static void clearNode(CompoundNBT nbt, int node) {
        nbt.func_82580_o("x" + node);
        nbt.func_82580_o("y" + node);
        nbt.func_82580_o("z" + node);
        nbt.func_82580_o("type" + node);
    }

    public void setNode(int var1, int var2, BlockPos var3, WireType var4);

    default public void removeNode(int node) {
        this.setNode(node, -1, null, null);
    }

    public BlockPos getNodePos(int var1);

    public WireType getNodeType(int var1);

    public int getOtherNodeIndex(int var1);

    public void invalidateNodeCache();

    default public boolean hasConnection(int node) {
        return this.getNodePos(node) != null;
    }

    default public boolean hasConnectionTo(BlockPos pos1) {
        if (pos1 == null) {
            return false;
        }
        for (int i = 0; i < this.getNodeCount(); ++i) {
            BlockPos pos2 = this.getNodePos(i);
            if (pos2 == null || !pos1.equals((Object)pos2)) continue;
            return true;
        }
        return false;
    }

    public static int findConnectionTo(IWireNode wn, BlockPos pos) {
        if (pos == null) {
            return -1;
        }
        for (int i = 0; i < wn.getNodeCount(); ++i) {
            BlockPos pos2 = wn.getNodePos(i);
            if (pos2 == null || !pos.equals((Object)pos2)) continue;
            return i;
        }
        return -1;
    }

    public BlockPos getMyPos();

    public IWireNode getNode(int var1);

    public static WireConnectResult connect(World world, BlockPos pos1, int node1, BlockPos pos2, int node2, WireType type) {
        TileEntity te1 = world.func_175625_s(pos1);
        if (te1 == null) {
            return WireConnectResult.INVALID;
        }
        TileEntity te2 = world.func_175625_s(pos2);
        if (te2 == null) {
            return WireConnectResult.INVALID;
        }
        if (te1 == te2) {
            return WireConnectResult.INVALID;
        }
        if (!(te1 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (!(te2 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (node1 < 0 || node2 < 0) {
            return WireConnectResult.COUNT;
        }
        if (pos1.func_177951_i((Vector3i)pos2) > 144.0) {
            return WireConnectResult.LONG;
        }
        IWireNode wn1 = (IWireNode)te1;
        IWireNode wn2 = (IWireNode)te2;
        if (wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.EXISTS;
        }
        wn1.setNode(node1, node2, wn2.getMyPos(), type);
        wn2.setNode(node2, node1, wn1.getMyPos(), type);
        return WireConnectResult.getLink(wn2.isNodeInput(node2), wn2.isNodeOutput(node2));
    }

    public static WireType getTypeOfConnection(World world, BlockPos pos1, BlockPos pos2) {
        TileEntity te1 = world.func_175625_s(pos1);
        if (te1 == null) {
            return null;
        }
        if (!(te1 instanceof IWireNode)) {
            return null;
        }
        IWireNode wn1 = (IWireNode)te1;
        if (!wn1.hasConnectionTo(pos2)) {
            return null;
        }
        int node1 = IWireNode.findConnectionTo(wn1, pos2);
        return wn1.getNodeType(node1);
    }

    public static WireConnectResult disconnect(World world, BlockPos pos1, BlockPos pos2) {
        TileEntity te1 = world.func_175625_s(pos1);
        if (te1 == null) {
            return WireConnectResult.INVALID;
        }
        TileEntity te2 = world.func_175625_s(pos2);
        if (te2 == null) {
            return WireConnectResult.INVALID;
        }
        if (te1 == te2) {
            return WireConnectResult.INVALID;
        }
        if (!(te1 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        if (!(te2 instanceof IWireNode)) {
            return WireConnectResult.INVALID;
        }
        IWireNode wn1 = (IWireNode)te1;
        IWireNode wn2 = (IWireNode)te2;
        if (!wn1.hasConnectionTo(pos2)) {
            return WireConnectResult.NO_CONNECTION;
        }
        int node1 = IWireNode.findConnectionTo(wn1, pos2);
        int node2 = IWireNode.findConnectionTo(wn2, pos1);
        if (node1 < 0) {
            return WireConnectResult.NO_CONNECTION;
        }
        if (node2 < 0) {
            return WireConnectResult.NO_CONNECTION;
        }
        wn1.removeNode(node1);
        wn2.removeNode(node2);
        return WireConnectResult.REMOVED;
    }

    public static IWireNode getWireNode(World world, BlockPos pos) {
        if (pos == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IWireNode)) {
            return null;
        }
        return (IWireNode)te;
    }

    default public boolean isNodeInput(int node) {
        return true;
    }

    default public boolean isNodeOutput(int node) {
        return true;
    }

    public static void dropWire(World world, BlockPos pos, ItemStack stack) {
        InventoryHelper.func_219961_a((World)world, (BlockPos)pos, (NonNullList)NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack}));
    }

    default public void dropWires(World world) {
        NonNullList stacks = NonNullList.func_191197_a((int)WireType.values().length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            int n = this.getNodeType(i).getIndex();
            if (((ItemStack)stacks.get(n)).func_190926_b()) {
                stacks.set(n, (Object)this.getNodeType(i).getDrop());
                continue;
            }
            ((ItemStack)stacks.get(n)).func_190917_f(this.getNodeType(i).getDrop().func_190916_E());
        }
        for (ItemStack stack : stacks) {
            IWireNode.dropWire(world, this.getMyPos(), stack);
        }
    }

    default public void dropWires(World world, PlayerEntity player) {
        NonNullList stacks1 = NonNullList.func_191197_a((int)WireType.values().length, (Object)ItemStack.field_190927_a);
        NonNullList stacks2 = NonNullList.func_191197_a((int)WireType.values().length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.getNodeType(i) == null) continue;
            int n = this.getNodeType(i).getIndex();
            ItemStack spools = Util.findStack(((WireSpool)CAItems.SPOOL.get()).getItem(), player.field_71071_by);
            if (spools.func_190916_E() > 0) {
                if (((ItemStack)stacks1.get(n)).func_190926_b()) {
                    stacks1.set(n, (Object)this.getNodeType(i).getSourceDrop());
                } else {
                    ((ItemStack)stacks1.get(n)).func_190917_f(this.getNodeType(i).getSourceDrop().func_190916_E());
                }
                spools.func_190918_g(1);
                continue;
            }
            if (((ItemStack)stacks2.get(n)).func_190926_b()) {
                stacks2.set(n, (Object)this.getNodeType(i).getDrop());
                continue;
            }
            ((ItemStack)stacks2.get(n)).func_190917_f(this.getNodeType(i).getDrop().func_190916_E());
        }
        for (ItemStack stack : stacks1) {
            if (stack.func_190926_b()) continue;
            IWireNode.dropWire(world, this.getMyPos(), player.field_71071_by.func_70441_a(stack) ? ItemStack.field_190927_a : stack);
        }
        for (ItemStack stack : stacks2) {
            if (stack.func_190926_b()) continue;
            IWireNode.dropWire(world, this.getMyPos(), player.field_71071_by.func_70441_a(stack) ? ItemStack.field_190927_a : stack);
        }
    }

    default public boolean isNodeIndeciesConnected(int in, int other) {
        return true;
    }

    default public boolean awakeNetwork(World world) {
        boolean b = false;
        for (int i = 0; i < this.getNodeCount(); ++i) {
            if (this.isNetworkValid(i)) continue;
            this.setNetwork(i, EnergyNetwork.nextNode(world, new EnergyNetwork(world), new HashMap<String, IWireNode>(), this, i));
            b = true;
        }
        return b;
    }

    public EnergyNetwork getNetwork(int var1);

    public void setNetwork(int var1, EnergyNetwork var2);

    default public boolean isNetworkValid(int node) {
        return this.getNetwork(node) == null ? false : this.getNetwork(node).isValid();
    }
}

