/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.network;

import com.mrh0.createaddition.CreateAddition;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class EnergyNetworkPacket {
    private BlockPos pos;
    private int demand;
    private int buff;
    public static double clientSaturation = 0.0;
    public static int clientDemand = 0;
    public static int clientBuff = 0;

    public EnergyNetworkPacket(BlockPos pos, int demand, int buff) {
        this.pos = pos;
        this.demand = demand;
        this.buff = buff;
    }

    public static void encode(EnergyNetworkPacket packet, PacketBuffer tag) {
        tag.func_179255_a(packet.pos);
        tag.writeInt(packet.demand);
        tag.writeInt(packet.buff);
    }

    public static EnergyNetworkPacket decode(PacketBuffer buf) {
        EnergyNetworkPacket scp = new EnergyNetworkPacket(buf.func_179259_c(), buf.readInt(), buf.readInt());
        return scp;
    }

    public static void handle(EnergyNetworkPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                EnergyNetworkPacket.updateClientCache(pkt.pos, pkt.demand, pkt.buff);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void updateClientCache(BlockPos pos, int demand, int buff) {
        clientDemand = demand;
        clientBuff = buff;
        clientSaturation = buff - demand;
    }

    public static void send(BlockPos pos, int demand, int buff, ServerPlayerEntity player) {
        CreateAddition.Network.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EnergyNetworkPacket(pos, demand, buff));
    }
}

