/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.core.util.helpers.RenderHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.compat.jei.TCoreJeiPlugin;
import cofh.thermal.core.util.recipes.machine.BrewerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachineBrewerScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class BrewerRecipeCategory
extends ThermalRecipeCategory<BrewerRecipe> {
    protected IDrawableStatic tankInput;
    protected IDrawableStatic tankOutput;
    protected IDrawableStatic inputOverlay;
    protected IDrawableStatic outputOverlay;

    public BrewerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachineBrewerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_BREWER_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2);
        this.progressFluidBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(0);
        this.tankInput = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.tankOutput = Drawables.getDrawables((IGuiHelper)guiHelper).getTank(1);
        this.inputOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.outputOverlay = Drawables.getDrawables((IGuiHelper)guiHelper).getTankOverlay(1);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(2), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.progressFluid = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(2), 200, IDrawableAnimated.StartDirection.LEFT, true);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(0), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends BrewerRecipe> getRecipeClass() {
        return BrewerRecipe.class;
    }

    public void setIngredients(BrewerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setInputs(VanillaTypes.FLUID, recipe.getInputFluids());
        ingredients.setOutputs(VanillaTypes.FLUID, recipe.getOutputFluids());
    }

    public void setRecipe(IRecipeLayout layout, BrewerRecipe recipe, IIngredients ingredients) {
        List inputItems = ingredients.getInputs(VanillaTypes.ITEM);
        List inputFluids = ingredients.getInputs(VanillaTypes.FLUID);
        List outputs = ingredients.getOutputs(VanillaTypes.FLUID);
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = layout.getFluidStacks();
        guiItemStacks.init(0, true, 51, 14);
        guiFluidStacks.init(0, true, 25, 11, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.inputOverlay));
        guiFluidStacks.init(1, false, 116, 11, 16, 40, TCoreJeiPlugin.tankSize((int)8000), false, TCoreJeiPlugin.tankOverlay((IDrawable)this.outputOverlay));
        guiItemStacks.set(0, (List)inputItems.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        guiFluidStacks.set(1, (List)outputs.get(0));
        TCoreJeiPlugin.addDefaultFluidTooltipCallback((IGuiFluidStackGroup)guiFluidStacks);
    }

    public void draw(BrewerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 78, 23);
        this.tankInput.draw(matrixStack, 24, 10);
        this.tankOutput.draw(matrixStack, 115, 10);
        this.speedBackground.draw(matrixStack, 52, 34);
        if (!recipe.getInputFluids().isEmpty()) {
            RenderHelper.drawFluid((MatrixStack)matrixStack, (int)78, (int)23, (FluidStack)((FluidStack)recipe.getInputFluids().get(0)), (int)24, (int)16);
            this.progressFluidBackground.draw(matrixStack, 78, 23);
            this.progressFluid.draw(matrixStack, 78, 23);
        } else {
            this.progress.draw(matrixStack, 78, 23);
        }
        this.speed.draw(matrixStack, 52, 34);
    }
}

