/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.jei.machine;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.core.util.recipes.machine.PulverizerRecipe;
import cofh.thermal.expansion.client.gui.machine.MachinePulverizerScreen;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.lib.compat.jei.Drawables;
import cofh.thermal.lib.compat.jei.ThermalRecipeCategory;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class PulverizerRecipeCategory
extends ThermalRecipeCategory<PulverizerRecipe> {
    public PulverizerRecipeCategory(IGuiHelper guiHelper, ItemStack icon, ResourceLocation uid) {
        super(guiHelper, icon, uid);
        this.background = guiHelper.drawableBuilder(MachinePulverizerScreen.TEXTURE, 26, 11, 124, 62).addPadding(0, 0, 16, 24).build();
        this.name = StringHelper.getTextComponent((String)TExpReferences.MACHINE_PULVERIZER_BLOCK.func_149739_a());
        this.progressBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getProgress(0);
        this.speedBackground = Drawables.getDrawables((IGuiHelper)guiHelper).getScale(3);
        this.progress = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getProgressFill(0), 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.speed = guiHelper.createAnimatedDrawable(Drawables.getDrawables((IGuiHelper)guiHelper).getScaleFill(3), 400, IDrawableAnimated.StartDirection.TOP, true);
    }

    public Class<? extends PulverizerRecipe> getRecipeClass() {
        return PulverizerRecipe.class;
    }

    public void setIngredients(PulverizerRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputItems());
        ingredients.setOutputs(VanillaTypes.ITEM, recipe.getOutputItems());
    }

    public void setRecipe(IRecipeLayout layout, PulverizerRecipe recipe, IIngredients ingredients) {
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        List catalysts = PulverizerRecipeManager.instance().getCatalysts();
        for (int i = 0; i < outputs.size(); ++i) {
            float chance = ((Float)recipe.getOutputItemChances().get(i)).floatValue();
            if (!(chance > 1.0f)) continue;
            for (ItemStack stack : (List)outputs.get(i)) {
                stack.func_190920_e((int)chance);
            }
        }
        IGuiItemStackGroup guiItemStacks = layout.getItemStacks();
        guiItemStacks.init(0, true, 33, 5);
        guiItemStacks.init(1, true, 33, 41);
        guiItemStacks.init(2, false, 96, 14);
        guiItemStacks.init(3, false, 114, 14);
        guiItemStacks.init(4, false, 96, 32);
        guiItemStacks.init(5, false, 114, 32);
        guiItemStacks.set(0, (List)inputs.get(0));
        if (recipe.isCatalyzable()) {
            guiItemStacks.set(1, catalysts);
        }
        for (int i = 0; i < outputs.size(); ++i) {
            guiItemStacks.set(i + 2, (List)outputs.get(i));
        }
        this.addCatalyzedItemTooltipCallback(guiItemStacks, recipe.getOutputItemChances(), 2);
    }

    public void draw(PulverizerRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        super.draw((ThermalRecipe)recipe, matrixStack, mouseX, mouseY);
        this.progressBackground.draw(matrixStack, 62, 23);
        this.speedBackground.draw(matrixStack, 34, 24);
        this.progress.draw(matrixStack, 62, 23);
        this.speed.draw(matrixStack, 34, 24);
    }
}

