/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.compat.patchouli;

import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.core.util.managers.machine.InsolatorRecipeManager;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.core.util.managers.machine.SmelterRecipeManager;
import cofh.thermal.lib.util.managers.CatalyzedRecipeManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class CatalystProcessor
implements IComponentProcessor {
    private ArrayList<CatalyzedRecipeManager> managers = new ArrayList();

    public void setup(IVariableProvider variables) {
        this.managers.add((CatalyzedRecipeManager)SmelterRecipeManager.instance());
        this.managers.add((CatalyzedRecipeManager)PulverizerRecipeManager.instance());
        this.managers.add((CatalyzedRecipeManager)InsolatorRecipeManager.instance());
    }

    public IVariable process(String key) {
        if (this.managers.size() == 0) {
            return null;
        }
        String[] keys = key.split("_");
        int machineIndex = keys[0].charAt(0) - 65;
        if (machineIndex < this.managers.size()) {
            if (keys.length == 2) {
                switch (keys[1]) {
                    case "machine": {
                        if (this.managers.get(machineIndex) instanceof SmelterRecipeManager) {
                            return IVariable.wrap((String)StringHelper.localize((String)"block.thermal.machine_smelter"));
                        }
                        if (this.managers.get(machineIndex) instanceof PulverizerRecipeManager) {
                            return IVariable.wrap((String)StringHelper.localize((String)"block.thermal.machine_pulverizer"));
                        }
                        if (this.managers.get(machineIndex) instanceof InsolatorRecipeManager) {
                            return IVariable.wrap((String)StringHelper.localize((String)"block.thermal.machine_insolator"));
                        }
                    }
                    case "enablejei": {
                        return IVariable.wrap((Boolean)(this.managers.get(machineIndex).getCatalysts().size() > 6 ? 1 : 0));
                    }
                }
                return null;
            }
            CatalyzedRecipeManager manager = this.managers.get(machineIndex);
            List catalysts = manager.getCatalysts();
            int catalystIndex = Integer.parseInt(keys[1]);
            if (catalystIndex < catalysts.size() && (catalystIndex < 5 || catalystIndex == 5 && catalysts.size() < 7)) {
                ItemStack catalyst = (ItemStack)catalysts.get(catalystIndex);
                switch (keys[2]) {
                    case "enable": {
                        return IVariable.wrap((Boolean)true);
                    }
                    case "item": {
                        return IVariable.wrap((String)catalyst.func_77973_b().getRegistryName().toString());
                    }
                    case "p": {
                        return IVariable.wrap((Number)Float.valueOf(manager.getCatalyst(catalyst).getPrimaryMod()));
                    }
                    case "s": {
                        return IVariable.wrap((Number)Float.valueOf(manager.getCatalyst(catalyst).getSecondaryMod()));
                    }
                    case "e": {
                        return IVariable.wrap((Number)Float.valueOf(manager.getCatalyst(catalyst).getEnergyMod()));
                    }
                    case "u": {
                        return IVariable.wrap((Number)((int)(manager.getCatalyst(catalyst).getUseChance() * 100.0f)));
                    }
                }
                return null;
            }
        }
        return null;
    }
}

