/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.dynamo;

import cofh.core.client.renderer.model.ModelUtils;
import cofh.core.network.packet.client.TileStatePacket;
import cofh.core.tileentity.TileCoFH;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.thermal.core.util.managers.dynamo.CompressionFuelManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.dynamo.DynamoCompressionContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DynamoTileBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fluids.FluidStack;

public class DynamoCompressionTile
extends DynamoTileBase {
    protected FluidStorageCoFH fuelTank = new FluidStorageCoFH(4000, fluid -> this.filter.valid(fluid) && CompressionFuelManager.instance().validFuel(fluid));

    public DynamoCompressionTile() {
        super(TExpReferences.DYNAMO_COMPRESSION_TILE);
        this.tankInv.addTank(this.fuelTank, StorageGroup.INPUT);
        this.renderFluid = new FluidStack((Fluid)Fluids.field_204546_a, 1000);
        this.addAugmentSlots(ThermalConfig.dynamoAugments);
        this.initHandlers();
    }

    protected boolean canProcessStart() {
        return CompressionFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) > 0 && this.fuelTank.getAmount() >= 100;
    }

    protected void processStart() {
        if (this.cacheRenderFluid()) {
            TileStatePacket.sendToClient((TileCoFH)this);
        }
        this.fuelMax = Math.round((float)CompressionFuelManager.instance().getEnergy(this.fuelTank.getFluidStack()) * this.energyMod);
        this.fuel += this.fuelMax;
        this.fuelTank.modify(-100);
    }

    protected boolean cacheRenderFluid() {
        FluidStack prevFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.fuelTank.getFluidStack(), 1000);
        return !FluidHelper.fluidsEqual((FluidStack)this.renderFluid, (FluidStack)prevFluid);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DynamoCompressionContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelUtils.FLUID, (Object)this.renderFluid).build();
    }
}

