/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import tv.mapper.embellishcraft.tileentity.CrateTileEntity;

public class CrateBlock
extends ContainerBlock {
    public static final ResourceLocation CONTENTS = new ResourceLocation("contents");

    public CrateBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CrateTileEntity) {
                INamedContainerProvider inamedcontainerprovider = this.func_220052_b(state, world, pos);
                if (inamedcontainerprovider != null) {
                    player.func_213829_a(inamedcontainerprovider);
                    world.func_184133_a(null, pos, SoundEvents.field_187875_gN, SoundCategory.BLOCKS, 1.0f, (float)(0.75 + Math.random() * 0.5));
                }
            } else {
                throw new IllegalStateException("Attempted to open a crate while it was not one!");
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tileentity;
            if (!worldIn.field_72995_K && player.func_184812_l_() && !crate.func_191420_l()) {
                ItemStack itemstack = new ItemStack((IItemProvider)this.getBlock());
                CompoundNBT compoundnbt = crate.saveToNbt(new CompoundNBT());
                if (!compoundnbt.isEmpty()) {
                    itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                }
                if (crate.func_145818_k_()) {
                    itemstack.func_200302_a(crate.func_200201_e());
                }
                ItemEntity itementity = new ItemEntity(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemstack);
                itementity.func_174869_p();
                worldIn.func_217376_c((Entity)itementity);
            } else {
                crate.func_184281_d(player);
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            if (compoundnbt.func_150297_b("LootTable", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("???????"));
            }
            if (compoundnbt.func_150297_b("Items", 9)) {
                NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.func_190926_b()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    IFormattableTextComponent itextcomponent = itemstack.func_200301_q().func_230532_e_();
                    itextcomponent.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                    tooltip.add((ITextComponent)itextcomponent);
                }
                if (j - i > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC));
                }
            }
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)tileentity;
            builder = builder.func_216017_a(CONTENTS, (p_220168_1_, p_220168_2_) -> {
                for (int i = 0; i < crate.func_70302_i_(); ++i) {
                    p_220168_2_.accept(crate.func_70301_a(i));
                }
            });
        }
        return super.func_220076_a(state, builder);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CrateTileEntity) {
                worldIn.func_175666_e(pos, state.func_177230_c());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CrateTileEntity();
    }

    @Nullable
    public ToolType getHarvestTool(BlockState state) {
        return super.getHarvestTool(state);
    }
}

