/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.data.gen;

import java.util.Arrays;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.DynamicLootEntry;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.loot.functions.CopyNbt;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetContents;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import tv.mapper.embellishcraft.block.CrateBlock;
import tv.mapper.embellishcraft.block.CustomBedBlock;
import tv.mapper.embellishcraft.block.ECBlockRegistry;
import tv.mapper.embellishcraft.block.PlateBlock;
import tv.mapper.embellishcraft.util.RockType;
import tv.mapper.mapperbase.data.gen.BaseLootTableProvider;

public class ECLootTables
extends BaseLootTableProvider {
    public ECLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected void addTables() {
        for (RegistryObject object : ECBlockRegistry.BLOCKS.getEntries()) {
            Block block = (Block)object.get();
            if (ECBlockRegistry.ROCK_BLOCKS.containsKey(block)) continue;
            if (block instanceof SlabBlock) {
                this.lootTables.put(block, this.createSlabTable("embellishcraft", block));
                continue;
            }
            if (block instanceof CustomBedBlock) {
                this.lootTables.put(block, this.createBedTable("embellishcraft", block));
                continue;
            }
            if (block instanceof DoorBlock) {
                this.lootTables.put(block, this.createDoorTable("embellishcraft", block));
                continue;
            }
            if (block instanceof CrateBlock) {
                this.lootTables.put(block, this.createCrateTable("embellishcraft", block));
                continue;
            }
            if (block instanceof ChestBlock) {
                this.lootTables.put(block, this.createChestTable(block.getRegistryName().toString(), block));
                continue;
            }
            if (block instanceof PlateBlock) {
                this.lootTables.put(block, this.createPlateTable("embellishcraft", block));
                continue;
            }
            this.lootTables.put(block, this.createStandardTable("embellishcraft", block));
        }
        int j = 0;
        while ((long)j < Arrays.stream(RockType.values()).count()) {
            this.lootTables.put(ECBlockRegistry.ROCK_BLOCKS.get((Object)RockType.byId(j)).get(), this.createSilkTable("embellishcraft", (Block)ECBlockRegistry.ROCK_BLOCKS.get((Object)RockType.byId(j)).get(), (Block)ECBlockRegistry.ROCK_COBBLESTONES.get((Object)RockType.byId(j)).get()));
            ++j;
        }
    }

    protected LootTable.Builder createPlateTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ECLootTables.withExplosionDecay((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 2)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)3)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 3)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)4)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 4)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)5)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 5)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)6)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 6)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)7)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 7)))).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)8)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)PlateBlock.PLATES, 8))))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }

    protected LootTable.Builder createCrateTable(String modid, Block block) {
        String name = block.getRegistryName().toString().replace(modid + ":", "");
        LootPool.Builder builder = LootPool.func_216096_a().name(name).func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Lock", "BlockEntityTag.Lock").func_216056_a("LootTable", "BlockEntityTag.LootTable").func_216056_a("LootTableSeed", "BlockEntityTag.LootTableSeed")).func_212841_b_((ILootFunction.IBuilder)SetContents.func_215920_b().func_216075_a((LootEntry.Builder)DynamicLootEntry.func_216162_a((ResourceLocation)CrateBlock.CONTENTS))));
        return LootTable.func_216119_b().func_216040_a(builder);
    }
}

