/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import tv.mapper.embellishcraft.EmbellishCraft;
import tv.mapper.embellishcraft.tileentity.VerticalChestTileEntity;

public class LockerUUIDPacket {
    private BlockPos pos;

    public LockerUUIDPacket(BlockPos pos) {
        this.pos = pos;
    }

    public static void encode(LockerUUIDPacket packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
    }

    public static LockerUUIDPacket decode(PacketBuffer buffer) {
        BlockPos pos = buffer.func_179259_c();
        LockerUUIDPacket instance = new LockerUUIDPacket(pos);
        return instance;
    }

    public static void handle(LockerUUIDPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            UUID id = player.func_110124_au();
            ServerWorld world = player.func_71121_q();
            TileEntity te = world.func_175625_s(packet.pos);
            if (te instanceof VerticalChestTileEntity) {
                if (!((VerticalChestTileEntity)te).hasUUID()) {
                    ((VerticalChestTileEntity)te).setUUID(id);
                } else {
                    EmbellishCraft.LOGGER.warn("WARNING: Attempted to change UUID on existing container, that's illegal!");
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

