/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.embellishcraft.tileentity;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import tv.mapper.embellishcraft.EmbellishCraft;
import tv.mapper.embellishcraft.block.CustomBedBlock;
import tv.mapper.embellishcraft.block.CustomChestBlock;
import tv.mapper.embellishcraft.block.ECBlockRegistry;
import tv.mapper.embellishcraft.tileentity.CrateTileEntity;
import tv.mapper.embellishcraft.tileentity.CustomBedTileEntity;
import tv.mapper.embellishcraft.tileentity.CustomChestTileEntity;
import tv.mapper.embellishcraft.tileentity.VerticalChestTileEntity;

@ObjectHolder(value="embellishcraft")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModTileEntityTypes {
    public static final TileEntityType<CustomChestTileEntity> CUSTOM_CHEST = null;
    public static final TileEntityType<VerticalChestTileEntity> VERTICAL_CHEST = null;
    public static final TileEntityType<VerticalChestTileEntity> CUSTOM_BED = null;
    public static final TileEntityType<CrateTileEntity> CRATE = null;

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        EmbellishCraft.LOGGER.info("1.3- EmbellishCraft: TE registering.");
        ArrayList<IForgeRegistryEntry> CHESTS = new ArrayList<IForgeRegistryEntry>();
        ArrayList<IForgeRegistryEntry> BEDS = new ArrayList<IForgeRegistryEntry>();
        ArrayList<IForgeRegistryEntry> CRATES = new ArrayList<IForgeRegistryEntry>();
        for (RegistryObject<CustomChestBlock> registryObject : ECBlockRegistry.FANCY_CHESTS) {
            CHESTS.add(registryObject.get());
        }
        EmbellishCraft.LOGGER.info("EmbellishCraft: if this line crashes please report to https://github.com/MapperTV/embellishcraft/issues/19");
        for (RegistryObject registryObject : ECBlockRegistry.FANCY_BEDS) {
            BEDS.add(registryObject.get());
        }
        for (RegistryObject registryObject : ECBlockRegistry.CRATES) {
            CRATES.add(registryObject.get());
        }
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(CustomChestTileEntity::new, (Block[])CHESTS.toArray(new Block[ECBlockRegistry.FANCY_CHESTS.size()])).func_206865_a(null).setRegistryName("custom_chest"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(VerticalChestTileEntity::new, (Block[])new Block[]{(Block)ECBlockRegistry.LOCKER.get()}).func_206865_a(null).setRegistryName("vertical_chest"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(CustomBedTileEntity::new, (Block[])((Block[])BEDS.toArray(new CustomBedBlock[ECBlockRegistry.FANCY_BEDS.size()]))).func_206865_a(null).setRegistryName("custom_bed"));
        event.getRegistry().register(TileEntityType.Builder.func_223042_a(CrateTileEntity::new, (Block[])CRATES.toArray(new Block[ECBlockRegistry.CRATES.size()])).func_206865_a(null).setRegistryName("crate"));
    }
}

