/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.CoFHCore;
import cofh.core.client.gui.element.ElementBase;
import cofh.core.util.helpers.RenderHelper;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.util.constants.Constants;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.BooleanSupplier;
import net.minecraft.util.ResourceLocation;

public class ElementSlot
extends ElementBase {
    protected ResourceLocation underlayTexture;
    protected ResourceLocation overlayTexture;
    protected BooleanSupplier drawUnderlay = Constants.TRUE;
    protected BooleanSupplier drawOverlay = Constants.TRUE;

    public ElementSlot(IGuiAccess gui, int posX, int posY) {
        super(gui, posX, posY);
    }

    public final ElementSlot setUnderlayTexture(String texture) {
        return this.setUnderlayTexture(texture, Constants.TRUE);
    }

    public final ElementSlot setUnderlayTexture(String texture, BooleanSupplier draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL underlay texture.");
            return this;
        }
        this.underlayTexture = new ResourceLocation(texture);
        this.drawUnderlay = draw;
        return this;
    }

    public final ElementSlot setOverlayTexture(String texture) {
        return this.setOverlayTexture(texture, Constants.TRUE);
    }

    public final ElementSlot setOverlayTexture(String texture, BooleanSupplier draw) {
        if (texture == null || draw == null) {
            CoFHCore.LOG.warn("Attempted to assign a NULL overlay texture.");
            return this;
        }
        this.overlayTexture = new ResourceLocation(texture);
        this.drawOverlay = draw;
        return this;
    }

    @Override
    public void drawBackground(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawSlot();
        this.drawUnderlayTexture();
        this.drawOverlayTexture();
    }

    protected void drawSlot() {
        RenderHelper.bindTexture(this.texture);
        this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
    }

    protected void drawUnderlayTexture() {
        if (this.drawUnderlay.getAsBoolean() && this.underlayTexture != null) {
            RenderHelper.bindTexture(this.underlayTexture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }

    protected void drawOverlayTexture() {
        if (this.drawOverlay.getAsBoolean() && this.overlayTexture != null) {
            RenderHelper.bindTexture(this.overlayTexture);
            this.drawTexturedModalRect(this.posX(), this.posY(), 0, 0, this.width, this.height);
        }
    }
}

