/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.lib.capability.CapabilityShieldItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cofh_core")
public class ShieldEvents {
    private ShieldEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        DamageSource source;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        if (!ShieldEvents.canBlockDamageSource(entity, source = event.getSource())) {
            return;
        }
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_180139_w()) {
            return;
        }
        ItemStack shield = entity.func_184607_cu();
        shield.getCapability(CapabilityShieldItem.SHIELD_ITEM_CAPABILITY).ifPresent(cap -> cap.onBlock(entity, source));
    }

    private static boolean canBlockDamageSource(LivingEntity living, DamageSource source) {
        Vector3d vec3d2;
        AbstractArrowEntity arrow;
        Entity entity = source.func_76364_f();
        if (entity instanceof AbstractArrowEntity && (arrow = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            return false;
        }
        if (!source.func_76363_c() && living.func_184585_cz() && (vec3d2 = source.func_188404_v()) != null) {
            Vector3d vec3d = living.func_70676_i(1.0f);
            Vector3d vec3d1 = vec3d2.func_72444_a(new Vector3d(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_())).func_72432_b();
            vec3d1 = new Vector3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            return vec3d1.func_72430_b(vec3d) < 0.0;
        }
        return false;
    }
}

