/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import cofh.core.command.SubCommandCrafting;
import cofh.core.command.SubCommandEnderChest;
import cofh.core.command.SubCommandHeal;
import cofh.core.command.SubCommandIgnite;
import cofh.core.command.SubCommandRepair;
import cofh.lib.enchantment.EnchantmentCoFH;
import cofh.lib.util.references.CoreReferences;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CoreConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static ForgeConfigSpec.IntValue permissionCrafting;
    public static ForgeConfigSpec.IntValue permissionEnderChest;
    public static ForgeConfigSpec.IntValue permissionHeal;
    public static ForgeConfigSpec.IntValue permissionIgnite;
    public static ForgeConfigSpec.IntValue permissionRepair;
    public static boolean improvedFeatherFalling;
    public static boolean improvedMending;
    public static boolean enableFishingExhaustion;
    public static float amountFishingExhaustion;
    public static boolean enableSaplingGrowthMod;
    public static int amountSaplingGrowthMod;
    public static boolean enableEnchantmentDescriptions;
    public static boolean enableItemDescriptions;
    public static boolean enableItemTags;
    public static boolean alwaysShowDetails;
    public static boolean holdShiftForDetails;
    private static ForgeConfigSpec.BooleanValue serverImprovedFeatherFalling;
    private static ForgeConfigSpec.BooleanValue serverImprovedMending;
    private static ForgeConfigSpec.BooleanValue serverEnableFishingExhaustion;
    private static ForgeConfigSpec.DoubleValue serverAmountFishingExhaustion;
    private static ForgeConfigSpec.BooleanValue serverEnableSaplingGrowthMod;
    private static ForgeConfigSpec.IntValue serverAmountSaplingGrowthMod;
    private static ForgeConfigSpec.BooleanValue clientEnableEnchantmentDescriptions;
    private static ForgeConfigSpec.BooleanValue clientEnableItemDescriptions;
    private static ForgeConfigSpec.BooleanValue clientEnableItemTags;
    private static ForgeConfigSpec.BooleanValue clientAlwaysShowDetails;
    private static ForgeConfigSpec.BooleanValue clientHoldShiftForDetails;
    private static ForgeConfigSpec.BooleanValue enableHolding;
    private static ForgeConfigSpec.BooleanValue treasureHolding;
    private static ForgeConfigSpec.IntValue levelHolding;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(CoreConfig.class);
        registered = true;
        CoreConfig.genServerConfig();
        CoreConfig.genClientConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private CoreConfig() {
    }

    private static void genServerConfig() {
        SERVER_CONFIG.push("Commands");
        permissionCrafting = SERVER_CONFIG.comment("The required permission level for the '/cofh crafting' command.").defineInRange("Crafting Permission Level", SubCommandCrafting.permissionLevel, 0, 4);
        permissionEnderChest = SERVER_CONFIG.comment("The required permission level for the '/cofh enderchest' command.").defineInRange("EnderChest Permission Level", SubCommandEnderChest.permissionLevel, 0, 4);
        permissionHeal = SERVER_CONFIG.comment("The required permission level for the '/cofh heal' command.").defineInRange("Heal Permission Level", SubCommandHeal.permissionLevel, 0, 4);
        permissionIgnite = SERVER_CONFIG.comment("The required permission level for the '/cofh ignite' command.").defineInRange("Ignite Permission Level", SubCommandIgnite.permissionLevel, 0, 4);
        permissionRepair = SERVER_CONFIG.comment("The required permission level for the '/cofh repair' command.").defineInRange("Repair Permission Level", SubCommandRepair.permissionLevel, 0, 4);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Enchantments");
        serverImprovedFeatherFalling = SERVER_CONFIG.comment("If TRUE, Feather Falling will prevent Farmland from being trampled. This option will work with alternative versions (overrides) of Feather Falling.").define("Improved Feather Falling", improvedFeatherFalling);
        serverImprovedMending = SERVER_CONFIG.comment("If TRUE, Mending behavior is altered so that Experience Orbs always repair items if possible, and the most damaged item is prioritized. This option may not work with alternative versions (overrides) of Mending.").define("Improved Mending", improvedMending);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("Fishing");
        serverEnableFishingExhaustion = SERVER_CONFIG.comment("If TRUE, Fishing will cause exhaustion.").define("Fishing Exhaustion", enableFishingExhaustion);
        serverAmountFishingExhaustion = SERVER_CONFIG.comment("This option sets the amount of exhaustion caused by fishing, if enabled.").defineInRange("Fishing Exhaustion Amount", (double)amountFishingExhaustion, 0.0, 10.0);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.push("World");
        serverEnableSaplingGrowthMod = SERVER_CONFIG.comment("If TRUE, Sapling growth will be slowed by a configurable factor.").define("Sapling Growth Reduction", enableSaplingGrowthMod);
        serverAmountSaplingGrowthMod = SERVER_CONFIG.comment("This option sets the growth factor for saplings - they will only grow 1 in N times.").defineInRange("Sapling Growth Reduction Factor", amountSaplingGrowthMod, 1, Integer.MAX_VALUE);
        SERVER_CONFIG.pop();
        serverSpec = SERVER_CONFIG.build();
        CoreConfig.refreshServerConfig();
    }

    private static void genClientConfig() {
        System.out.println("Client config gen");
        CLIENT_CONFIG.push("Tooltips");
        clientEnableEnchantmentDescriptions = CLIENT_CONFIG.comment("If TRUE, Enchantment descriptions will be added to the tooltip for Enchanted Books containing only a single enchantment.").define("Show Enchantment Descriptions", enableEnchantmentDescriptions);
        clientEnableItemDescriptions = CLIENT_CONFIG.comment("If TRUE, Item descriptions will be added to their tooltips if possible.").define("Show Item Descriptions", enableItemDescriptions);
        clientEnableItemTags = CLIENT_CONFIG.comment("If TRUE and Advanced Tooltips are enabled (F3+H), Tags will be will be added to item tooltips if possible.").define("Show Item Tags", enableItemTags);
        clientAlwaysShowDetails = CLIENT_CONFIG.comment("If TRUE, CoFH Items will always show full details (charge state, etc.) and will not require Shift to be held down.").define("Always Show Item Details", alwaysShowDetails);
        clientHoldShiftForDetails = CLIENT_CONFIG.comment("If TRUE, CoFH Items will display a message prompting to hold Shift to see full details (charge state, etc.). This does not change the behavior, only if the informational message should display.").define("Show 'Hold Shift for Details' Message", holdShiftForDetails);
        CLIENT_CONFIG.pop();
        clientSpec = CLIENT_CONFIG.build();
        CoreConfig.refreshClientConfig();
    }

    private static void genEnchantmentConfig() {
        String treasure = "This sets whether or not the Enchantment is considered a 'treasure' enchantment.";
        String level = "This option adjusts the maximum allowable level for the Enchantment.";
        SERVER_CONFIG.push("Enchantments");
        SERVER_CONFIG.push("Holding");
        enableHolding = SERVER_CONFIG.comment("If TRUE, the Holding Enchantment is available for various Storage Items and Blocks.").define("Enable", true);
        treasureHolding = SERVER_CONFIG.comment(treasure).define("Treasure", false);
        levelHolding = SERVER_CONFIG.comment(level).defineInRange("Max Level", 4, 1, 10);
        SERVER_CONFIG.pop();
        SERVER_CONFIG.pop();
    }

    private static void refreshServerConfig() {
        SubCommandCrafting.permissionLevel = (Integer)permissionCrafting.get();
        SubCommandEnderChest.permissionLevel = (Integer)permissionEnderChest.get();
        SubCommandHeal.permissionLevel = (Integer)permissionHeal.get();
        SubCommandIgnite.permissionLevel = (Integer)permissionIgnite.get();
        SubCommandRepair.permissionLevel = (Integer)permissionRepair.get();
        improvedFeatherFalling = (Boolean)serverImprovedFeatherFalling.get();
        improvedMending = (Boolean)serverImprovedMending.get();
        enableFishingExhaustion = (Boolean)serverEnableFishingExhaustion.get();
        amountFishingExhaustion = ((Double)serverAmountFishingExhaustion.get()).floatValue();
        enableSaplingGrowthMod = (Boolean)serverEnableSaplingGrowthMod.get();
        amountSaplingGrowthMod = (Integer)serverAmountSaplingGrowthMod.get();
    }

    private static void refreshClientConfig() {
        enableEnchantmentDescriptions = (Boolean)clientEnableEnchantmentDescriptions.get();
        enableItemDescriptions = (Boolean)clientEnableItemDescriptions.get();
        enableItemTags = (Boolean)clientEnableItemTags.get();
        alwaysShowDetails = (Boolean)clientAlwaysShowDetails.get();
        holdShiftForDetails = (Boolean)clientHoldShiftForDetails.get();
    }

    private static void refreshEnchantmentConfig() {
        if (CoreReferences.HOLDING instanceof EnchantmentCoFH) {
            ((EnchantmentCoFH)CoreReferences.HOLDING).setEnable((Boolean)enableHolding.get());
            ((EnchantmentCoFH)CoreReferences.HOLDING).setTreasureEnchantment((Boolean)treasureHolding.get());
            ((EnchantmentCoFH)CoreReferences.HOLDING).setMaxLevel((Integer)levelHolding.get());
        }
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                CoreConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                CoreConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                CoreConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                CoreConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
        improvedFeatherFalling = true;
        improvedMending = true;
        enableFishingExhaustion = false;
        amountFishingExhaustion = 0.125f;
        enableSaplingGrowthMod = false;
        amountSaplingGrowthMod = 4;
        enableEnchantmentDescriptions = true;
        enableItemDescriptions = true;
        enableItemTags = true;
        alwaysShowDetails = false;
        holdShiftForDetails = true;
    }
}

