/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.item.ItemCoFH;
import cofh.core.util.helpers.FluidHelper;
import cofh.lib.fluid.FluidContainerItemWrapper;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.ContainerType;
import cofh.lib.item.IColorableItem;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;

public class FluidContainerItem
extends ItemCoFH
implements IFluidContainerItem,
IColorableItem {
    protected Predicate<FluidStack> validator;
    protected int fluidCapacity;

    public FluidContainerItem(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder);
        this.fluidCapacity = fluidCapacity;
        this.validator = validator;
        this.setEnchantability(5);
    }

    public FluidContainerItem(Item.Properties builder, int fluidCapacity) {
        this(builder, fluidCapacity, e -> true);
    }

    @Override
    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((ITextComponent)StringHelper.getFluidName(fluid));
        }
        boolean creative = this.isCreative(stack, ContainerType.FLUID);
        tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + (creative ? StringHelper.localize("info.cofh.infinite") : StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB")));
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add((ITextComponent)StringHelper.getEmptyLine());
            tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects") + ":"));
            FluidHelper.addPotionTooltip(fluid, tooltip);
        }
    }

    protected void potionTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, List<EffectInstance> effects) {
        this.potionTooltip(stack, worldIn, tooltip, flagIn, effects, 1.0f);
    }

    protected void potionTooltip(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn, List<EffectInstance> effects, float durationFactor) {
        FluidStack fluid = this.getFluid(stack);
        if (!fluid.isEmpty()) {
            tooltip.add((ITextComponent)StringHelper.getFluidName(fluid));
        }
        tooltip.add((ITextComponent)(this.isCreative(stack, ContainerType.FLUID) ? StringHelper.getTextComponent("info.cofh.infinite_source") : StringHelper.getTextComponent(StringHelper.localize("info.cofh.amount") + ": " + StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB")));
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add((ITextComponent)StringHelper.getEmptyLine());
            tooltip.add((ITextComponent)StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects") + ":"));
            FluidHelper.addPotionTooltip(effects, tooltip, durationFactor);
        }
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return newStack.func_77973_b() != oldStack.func_77973_b() || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid");
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative(stack, ContainerType.FLUID) && this.getFluidAmount(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp(1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack), 0.0, 1.0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidContainerItemWrapper(stack, this);
    }

    @Override
    public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return this.validator.test(resource);
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.getMaxStored(container, this.fluidCapacity);
    }

    @Override
    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 1) {
            return this.getFluidAmount(stack) > 0 ? this.getFluid(stack).getFluid().getAttributes().getColor(this.getFluid(stack)) : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }
}

