/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.crops;

import cofh.lib.block.IHarvestable;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class CropsBlockCoFH
extends CropsBlock
implements IHarvestable {
    protected final PlantType type;
    protected int growLight;
    protected float growMod;
    protected Supplier<Item> crop = () -> Items.field_190931_a;
    protected Supplier<Item> seed = () -> Items.field_190931_a;

    public CropsBlockCoFH(AbstractBlock.Properties builder, PlantType type, int growLight, float growMod) {
        super(builder);
        this.type = type;
        this.growLight = growLight;
        this.growMod = growMod;
    }

    public CropsBlockCoFH(AbstractBlock.Properties builder, int growLight, float growMod) {
        this(builder, PlantType.CROP, growLight, growMod);
    }

    public CropsBlockCoFH(AbstractBlock.Properties builder) {
        this(builder, PlantType.CROP, 9, 1.0f);
    }

    public CropsBlockCoFH growMod(float growMod) {
        this.growMod = growMod;
        return this;
    }

    public CropsBlockCoFH crop(Supplier<Item> crop) {
        this.crop = crop;
        return this;
    }

    public CropsBlockCoFH seed(Supplier<Item> seed) {
        this.seed = seed;
        return this;
    }

    protected IItemProvider getCropItem() {
        return (IItemProvider)this.crop.get();
    }

    protected IItemProvider func_199772_f() {
        return (IItemProvider)this.seed.get();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{this.func_185524_e()});
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= this.growLight && !this.canHarvest(state)) {
            int age = this.func_185527_x(state);
            float growthChance = MathHelper.maxF(CropsBlockCoFH.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos) * this.growMod, 0.1f);
            if (ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / growthChance) + 1) == 0 ? 1 : 0) != 0)) {
                int newAge = age + 1 == this.getPostHarvestAge() ? this.func_185526_g() : age + 1;
                worldIn.func_180501_a(pos, this.func_185528_e(newAge), 2);
                ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_184614_ca().func_190926_b()) {
            return this.harvest(worldIn, pos, state, Utils.getItemEnchantmentLevel(Enchantments.field_185308_t, player.func_184586_b(handIn))) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Constants.CROPS_BY_AGE[MathHelper.clamp((Integer)state.func_177229_b((Property)this.func_185524_e()), 0, Constants.CROPS_BY_AGE.length - 1)];
    }

    public static float getGrowthChanceProxy(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        return CropsBlockCoFH.func_180672_a((Block)blockIn, (IBlockReader)worldIn, (BlockPos)pos);
    }

    public IntegerProperty func_185524_e() {
        return Constants.AGE_0_7;
    }

    protected int func_185527_x(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.func_185524_e());
    }

    protected int getPostHarvestAge() {
        return -1;
    }

    public BlockState func_185528_e(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.func_185524_e(), (Comparable)Integer.valueOf(age));
    }

    @Override
    public boolean canHarvest(BlockState state) {
        return this.func_185525_y(state);
    }

    @Override
    public boolean harvest(World world, BlockPos pos, BlockState state, int fortune) {
        if (!this.canHarvest(state)) {
            return false;
        }
        if (Utils.isClientWorld(world)) {
            return true;
        }
        if (this.getPostHarvestAge() >= 0) {
            Utils.dropItemStackIntoWorldWithRandomness(new ItemStack(this.getCropItem(), 2 + MathHelper.binomialDist(fortune, 0.5)), world, pos);
            world.func_180501_a(pos, this.func_185528_e(this.getPostHarvestAge()), 2);
        } else {
            world.func_175655_b(pos, true);
        }
        return true;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.canHarvest(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (this.canHarvest(state)) {
            return;
        }
        int postHarvest = this.getPostHarvestAge();
        int age = this.func_185527_x(state);
        int newAge = age + this.func_185529_b((World)worldIn);
        if (age < postHarvest && newAge >= postHarvest) {
            worldIn.func_180501_a(pos, this.func_185528_e(this.func_185526_g()), 2);
        } else {
            worldIn.func_180501_a(pos, this.func_185528_e(Math.min(newAge, this.func_185526_g())), 2);
        }
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return this.type;
    }
}

