/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.client.renderer.model;

import java.util.Arrays;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RetexturedBakedQuad
extends BakedQuad {
    private final TextureAtlasSprite texture;

    public RetexturedBakedQuad(BakedQuad quad, TextureAtlasSprite textureIn) {
        super(Arrays.copyOf(quad.func_178209_a(), quad.func_178209_a().length), quad.func_178211_c(), FaceBakery.func_178410_a((int[])quad.func_178209_a()), quad.func_187508_a(), quad.func_239287_f_());
        this.texture = textureIn;
        this.remapQuad();
    }

    private void remapQuad() {
        for (int i = 0; i < 4; ++i) {
            int j = DefaultVertexFormats.field_176600_a.func_181719_f() * i;
            int uvIndex = 4;
            this.field_178215_a[j + uvIndex] = Float.floatToRawIntBits(this.texture.func_94214_a((double)RetexturedBakedQuad.getUnInterpolatedU(this.field_187509_d, Float.intBitsToFloat(this.field_178215_a[j + uvIndex]))));
            this.field_178215_a[j + uvIndex + 1] = Float.floatToRawIntBits(this.texture.func_94207_b((double)RetexturedBakedQuad.getUnInterpolatedV(this.field_187509_d, Float.intBitsToFloat(this.field_178215_a[j + uvIndex + 1]))));
        }
    }

    public TextureAtlasSprite func_187508_a() {
        return this.texture;
    }

    private static float getUnInterpolatedU(TextureAtlasSprite sprite, float u) {
        float f = sprite.func_94212_f() - sprite.func_94209_e();
        return (u - sprite.func_94209_e()) / f * 16.0f;
    }

    private static float getUnInterpolatedV(TextureAtlasSprite sprite, float v) {
        float f = sprite.func_94210_h() - sprite.func_94206_g();
        return (v - sprite.func_94206_g()) / f * 16.0f;
    }
}

