/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.util.IInventoryCallback;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class ManagedItemHandler
extends SimpleItemHandler {
    protected List<ItemStorageCoFH> inputSlots;
    protected List<ItemStorageCoFH> outputSlots;
    protected boolean preventInputExtract = false;

    public ManagedItemHandler(@Nullable IInventoryCallback tile, @Nonnull List<ItemStorageCoFH> inputSlots, @Nonnull List<ItemStorageCoFH> outputSlots) {
        super(tile);
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.slots.addAll(inputSlots);
        this.slots.addAll(outputSlots);
    }

    public ManagedItemHandler restrict() {
        this.preventInputExtract = true;
        return this;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot < 0 || slot >= this.inputSlots.size()) {
            return stack;
        }
        ItemStack cur = ((ItemStorageCoFH)this.slots.get(slot)).getItemStack();
        ItemStack ret = ((ItemStorageCoFH)this.slots.get(slot)).insertItem(slot, stack, simulate);
        if (!simulate && cur.func_77973_b() != ((ItemStorageCoFH)this.slots.get(slot)).getItemStack().func_77973_b()) {
            this.onInventoryChange(slot);
        }
        return ret;
    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int minSlot;
        int n = minSlot = this.preventInputExtract ? this.inputSlots.size() : 0;
        if (slot < minSlot || slot > this.getSlots()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = ((ItemStorageCoFH)this.slots.get(slot)).extractItem(slot, amount, simulate);
        if (!simulate) {
            this.onInventoryChange(slot);
        }
        return ret;
    }
}

