/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.chunkdata;

import javax.annotation.Nonnull;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import team.chisel.api.chunkdata.IChunkDataRegistry;
import team.chisel.api.chunkdata.IOffsetData;

public class ChunkData {
    private static IChunkDataRegistry offsetRegistry;
    public static final String OFFSET_DATA_KEY = "offsettool";
    private static final IOffsetData DUMMY;

    public static void setOffsetRegistry(IChunkDataRegistry registry) {
        if (offsetRegistry != null) {
            throw new IllegalStateException();
        }
        offsetRegistry = registry;
    }

    public static IOffsetData getOffsetForChunk(World world, @Nonnull BlockPos pos) {
        return ChunkData.getOffsetForChunk(world.func_175726_f(pos));
    }

    public static IOffsetData getOffsetForChunk(Chunk chunk) {
        return ChunkData.getOffsetForChunk((RegistryKey<World>)chunk.func_177412_p().func_234923_W_(), chunk.func_76632_l());
    }

    public static IOffsetData getOffsetForChunk(RegistryKey<World> dimID, ChunkPos chunk) {
        Object data = offsetRegistry.getData(OFFSET_DATA_KEY);
        return data == null ? DUMMY : (IOffsetData)data.getDataForChunk(dimID, chunk);
    }

    static {
        DUMMY = new IOffsetData(){
            private final BlockPos ZERO = new BlockPos(0, 0, 0);

            @Override
            public BlockPos getOffset() {
                return this.ZERO;
            }
        };
    }
}

