/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import team.chisel.api.block.ICarvable;
import team.chisel.client.util.ChiselLangKeys;
import team.chisel.common.config.Configurations;

@ParametersAreNonnullByDefault
public class ItemChiselBlock
extends BlockItem {
    private ICarvable block;

    public ItemChiselBlock(Block block, Item.Properties properties) {
        super(block, properties);
        this.block = (ICarvable)block;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Configurations.blockDescriptions) {
            tooltip.add((ITextComponent)this.block.getVariation().getDisplayName().func_240699_a_(TextFormatting.GRAY));
        }
        ItemChiselBlock.addTooltips(stack, this.block, tooltip);
    }

    public static void addTooltips(ItemStack stack, List<ITextComponent> tooltip) {
        ItemChiselBlock.addTooltips(stack, ((ItemChiselBlock)stack.func_77973_b()).block, tooltip);
    }

    public static void addTooltips(ItemStack stack, ICarvable block, List<ITextComponent> tooltip) {
        try {
            int line = 1;
            String desc = block.getVariation().getDisplayName().func_150268_i() + ".desc.";
            while (I18n.func_188566_a((String)(desc + line))) {
                tooltip.add((ITextComponent)new TranslationTextComponent(desc + line).func_240699_a_(TextFormatting.GRAY));
                desc.replaceAll(line++ + "$", "." + line);
            }
        }
        catch (Exception ignored) {
            tooltip.add((ITextComponent)new TranslationTextComponent("chisel.tooltip.invalid"));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent ret = super.func_200295_i(stack);
        if (!Configurations.blockDescriptions) {
            ret = ChiselLangKeys.TT_BLOCK_NAME.format(ret, this.block.getVariation().getDisplayName());
        }
        return ret;
    }
}

