/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.block;

import java.util.EnumMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.DiggingParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.Validate;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.block.MessageAutochiselFX;
import team.chisel.common.block.MessageUpdateAutochiselSource;
import team.chisel.common.config.Configurations;
import team.chisel.common.init.ChiselTileEntities;
import team.chisel.common.inventory.ContainerAutoChisel;
import team.chisel.common.util.SoundUtil;

@ParametersAreNonnullByDefault
public class TileAutoChisel
extends TileEntity
implements ITickableTileEntity,
INameable,
INamedContainerProvider {
    private static final int INPUT_COUNT = 12;
    private static final int OUTPUT_COUNT = 12;
    private static final int MAX_PROGRESS = 1024;
    private static final int BASE_PROGRESS = 16;
    private static final int SPEEDUP_PROGRESS = 64;
    private static final int POWER_PER_TICK = 20;
    private final ItemStackHandler otherInv = new DirtyingStackHandler(2){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return stack;
            }
            if (slot == 0 && stack.func_77973_b() instanceof IChiselItem) {
                return super.insertItem(slot, stack, simulate);
            }
            if (slot == 1 && CarvingUtils.getChiselRegistry().getVariation(stack.func_77973_b()) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final ItemStackHandler inputInv = new DirtyingStackHandler(12){

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!stack.func_190926_b() && CarvingUtils.getChiselRegistry().getVariation(stack.func_77973_b()) != null) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }
    };
    private final ItemStackHandler outputInv = new DirtyingStackHandler(12);
    private final EnergyStorageMutable energyStorage = new EnergyStorageMutable(10000, 40, 20);
    public final IIntArray energyData = new IIntArray(){

        public int func_221478_a() {
            return 6;
        }

        public void func_221477_a(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileAutoChisel.this.sourceSlot >= 0 ? 1 : 0;
                }
                case 1: {
                    return TileAutoChisel.this.progress;
                }
                case 2: {
                    return 1024;
                }
                case 3: {
                    return TileAutoChisel.this.energyStorage.getEnergyStored();
                }
                case 4: {
                    return TileAutoChisel.this.energyStorage.getMaxEnergyStored();
                }
                case 5: {
                    return TileAutoChisel.this.getUsagePerTick();
                }
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }
    };
    private int sourceSlot = -1;
    private int prevSource = -1;
    private int progress = 0;
    @Nullable
    private ITextComponent customName;
    private final EnumMap<Direction, LazyOptional<IItemHandler>> viewCache = new EnumMap(Direction.class);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> new EnergyView());
    @Nullable
    private ItemStack source;

    public TileAutoChisel() {
        super(ChiselTileEntities.AUTO_CHISEL_TE.get());
    }

    public IItemHandler getOtherInv() {
        return this.otherInv;
    }

    public ItemStack getChisel() {
        return this.getOtherInv().getStackInSlot(0);
    }

    public ItemStack getTarget() {
        return this.getOtherInv().getStackInSlot(1);
    }

    public IItemHandler getInputInv() {
        return this.inputInv;
    }

    public IItemHandler getOutputInv() {
        return this.outputInv;
    }

    public int getMaxProgress() {
        return 1024;
    }

    public float getSpeedFactor() {
        return Configurations.autoChiselPowered ? (float)this.energyStorage.getEnergyStored() / (float)this.energyStorage.getMaxEnergyStored() : 1.0f;
    }

    public int getPowerProgressPerTick() {
        int maxPerTick = Configurations.autoChiselNeedsPower ? 80 : 64;
        return (int)Math.ceil(this.getSpeedFactor() * (float)maxPerTick);
    }

    public int getUsagePerTick() {
        return (int)Math.ceil(this.getSpeedFactor() * 20.0f);
    }

    public void setEnergy(int energy) {
        this.energyStorage.setEnergyStored(energy);
    }

    protected boolean canOutput(ItemStack stack) {
        ItemStack res = stack;
        for (int i = 0; i < this.getOutputInv().getSlots(); ++i) {
            res = this.getOutputInv().insertItem(i, res, true);
            if (!res.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    protected void setSourceSlot(int slot) {
        this.sourceSlot = slot;
    }

    protected void updateClientSlot() {
        if (this.sourceSlot != this.prevSource) {
            Chisel.network.send(PacketDistributor.TRACKING_CHUNK.with(() -> (Chunk)this.func_145831_w().func_217349_x(this.func_174877_v())), (Object)new MessageUpdateAutochiselSource(this.func_174877_v(), this.sourceSlot < 0 ? ItemStack.field_190927_a : this.inputInv.getStackInSlot(this.sourceSlot)));
        }
        this.prevSource = this.sourceSlot;
    }

    protected void mergeOutput(ItemStack stack) {
        for (int i = 0; stack != null && i < this.getOutputInv().getSlots(); ++i) {
            stack = this.getOutputInv().insertItem(i, stack, false);
        }
    }

    public void func_73660_a() {
        ICarvingGroup g;
        if (this.func_145831_w() == null || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.energyStorage.getEnergyStored() == 0 && Configurations.autoChiselNeedsPower) {
            return;
        }
        ItemStack target = this.getTarget();
        ItemStack chisel = this.getChisel();
        ItemStack source = this.sourceSlot < 0 ? ItemStack.field_190927_a : this.getInputInv().getStackInSlot(this.sourceSlot);
        chisel = chisel.func_190926_b() ? ItemStack.field_190927_a : chisel.func_77946_l();
        ICarvingVariation v = target.func_190926_b() || chisel.func_190926_b() ? null : (ICarvingVariation)CarvingUtils.getChiselRegistry().getVariation(target.func_77973_b()).orElse(null);
        ICarvingGroup iCarvingGroup = g = target.func_190926_b() || chisel.func_190926_b() ? null : (ICarvingGroup)CarvingUtils.getChiselRegistry().getGroup(target.func_77973_b()).orElse(null);
        if (chisel.func_190926_b() || v == null) {
            this.setSourceSlot(-1);
            this.progress = 0;
            this.updateClientSlot();
            return;
        }
        if (!source.func_190926_b() && !CarvingUtils.getChiselRegistry().getGroup(source.func_77973_b()).equals(g)) {
            source = ItemStack.field_190927_a;
        }
        IChiselItem chiselitem = (IChiselItem)chisel.func_77973_b();
        if (this.sourceSlot < 0 && this.func_145831_w().func_82737_E() % 20L == 0L || this.sourceSlot >= 0) {
            if (source.func_190926_b()) {
                this.setSourceSlot(-1);
            }
            ItemStack res = new ItemStack((IItemProvider)v.getItem());
            if (!source.func_190926_b()) {
                res.func_190920_e(source.func_190916_E());
            }
            if (source.func_190926_b() || this.canOutput(res)) {
                for (int i = 0; this.sourceSlot < 0 && i < this.getInputInv().getSlots(); ++i) {
                    ItemStack stack = this.getInputInv().getStackInSlot(i);
                    if (stack.func_190926_b() || !g.equals(CarvingUtils.getChiselRegistry().getGroup(stack.func_77973_b()).orElse(null))) continue;
                    res.func_190920_e(stack.func_190916_E());
                    if (!this.canOutput(res) || !chiselitem.canChisel(this.func_145831_w(), (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.func_145831_w())), chisel, v)) continue;
                    this.setSourceSlot(i);
                    source = res.func_77946_l();
                }
            } else {
                this.setSourceSlot(-1);
            }
        }
        if (this.sourceSlot >= 0) {
            source = this.getInputInv().getStackInSlot(this.sourceSlot);
            Validate.notNull((Object)source);
            ICarvingVariation sourceVar = CarvingUtils.getChiselRegistry().getVariation(source.func_77973_b()).orElse(null);
            if (sourceVar != v) {
                if (this.progress < 1024) {
                    if (!Configurations.autoChiselNeedsPower) {
                        this.progress = Math.min(1024, this.progress + 16);
                    }
                    int toUse = Math.min(1024 - this.progress, this.getPowerProgressPerTick());
                    int powerToUse = this.getUsagePerTick();
                    if (toUse > 0 && powerToUse > 0) {
                        if (Configurations.autoChiselPowered) {
                            int used = this.energyStorage.extractEnergy(powerToUse, false);
                            this.progress = (int)((float)this.progress + (float)toUse * ((float)used / (float)powerToUse));
                        } else {
                            this.progress += toUse;
                        }
                    }
                } else {
                    ItemStack res = new ItemStack((IItemProvider)v.getItem());
                    source = source.func_77946_l();
                    chisel = chisel.func_77946_l();
                    FakePlayer player = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.func_145831_w()));
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)chisel);
                    res = chiselitem.craftItem(chisel, source, res, (PlayerEntity)player, $ -> {});
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                    chiselitem.onChisel(this.func_145831_w(), (PlayerEntity)player, chisel, v);
                    this.inputInv.setStackInSlot(this.sourceSlot, source);
                    Chisel.network.send(PacketDistributor.NEAR.with(this.targetNearby()), (Object)new MessageAutochiselFX(this.func_174877_v(), chisel, sourceVar.getBlock().func_176223_P()));
                    this.otherInv.setStackInSlot(0, chisel);
                    this.mergeOutput(res);
                    this.setSourceSlot((this.sourceSlot + 1) % this.getInputInv().getSlots());
                    this.progress = 0;
                }
            } else {
                this.inputInv.setStackInSlot(this.sourceSlot, ItemStack.field_190927_a);
                this.mergeOutput(source);
            }
        } else {
            this.progress = 0;
        }
        this.updateClientSlot();
    }

    private Supplier<PacketDistributor.TargetPoint> targetNearby() {
        Vector3d pos = Vector3d.func_237491_b_((Vector3i)this.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
        return PacketDistributor.TargetPoint.p((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (double)4096.0, (RegistryKey)this.func_145831_w().func_234923_W_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, this.viewCache.computeIfAbsent(facing, f -> LazyOptional.of(() -> new ItemView((Direction)f))));
        }
        if (Configurations.autoChiselPowered && capability == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(capability, this.energyCap);
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT ret = super.func_189517_E_();
        if (this.func_145818_k_()) {
            ret.func_74778_a("customName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200200_C_()));
        }
        return ret;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(this.func_145831_w().func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
        super.onDataPacket(net, pkt);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        if (tag.func_74764_b("customName")) {
            this.setCustomName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("customName")));
        }
        super.handleUpdateTag(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("other", (INBT)this.otherInv.serializeNBT());
        compound.func_218657_a("input", (INBT)this.inputInv.serializeNBT());
        compound.func_218657_a("output", (INBT)this.outputInv.serializeNBT());
        compound.func_74768_a("energy", this.energyStorage.getEnergyStored());
        compound.func_74768_a("progress", this.getProgress());
        compound.func_74768_a("source", this.sourceSlot);
        if (this.func_145818_k_()) {
            compound.func_74778_a("customName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200200_C_()));
        }
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.otherInv.deserializeNBT(compound.func_74775_l("other"));
        this.inputInv.deserializeNBT(compound.func_74775_l("input"));
        this.outputInv.deserializeNBT(compound.func_74775_l("output"));
        this.energyStorage.setEnergyStored(compound.func_74762_e("energy"));
        this.progress = compound.func_74762_e("progress");
        this.sourceSlot = compound.func_74762_e("source");
        if (compound.func_74764_b("customName")) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)compound.func_74779_i("customName"));
        }
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? this.func_200201_e() : this.func_200200_C_();
    }

    public ITextComponent func_200200_C_() {
        ITextComponent name = this.func_200201_e();
        if (name == null) {
            name = new TranslationTextComponent("container.autochisel.title");
        }
        return name;
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInv, PlayerEntity p_createMenu_3_) {
        return new ContainerAutoChisel(ChiselTileEntities.AUTO_CHISEL_CONTAINER.get(), windowId, playerInv, this.getInputInv(), this.getOutputInv(), this.getOtherInv(), this.energyData, IWorldPosCallable.func_221488_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v()));
    }

    public void spawnCompletionFX(PlayerEntity player, ItemStack chisel, BlockState source) {
        SoundUtil.playSound(player, this.func_174877_v(), SoundUtil.getSound(player, chisel, source.func_177230_c()));
        if (chisel.func_190926_b()) {
            this.func_145831_w().func_184133_a(player, this.field_174879_c, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
        }
        int i = 3;
        float mid = (float)i / 2.0f;
        for (int j = 0; j < i; ++j) {
            for (int k = 0; k < i; ++k) {
                for (int l = 0; l < i; ++l) {
                    double vx = (double)(mid - (float)j) * 0.05;
                    double vz = (double)(mid - (float)l) * 0.05;
                    Particle fx = Minecraft.func_71410_x().field_71452_i.func_199280_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, source), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.625, (double)this.field_174879_c.func_177952_p() + 0.5, vx, 0.0, vz);
                    if (fx == null) continue;
                    ((DiggingParticle)fx).func_174846_a(this.field_174879_c);
                }
            }
        }
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setCustomName(@Nullable ITextComponent customName) {
        this.customName = customName;
    }

    public void setSource(@Nullable ItemStack source) {
        this.source = source;
    }

    @Nullable
    public ItemStack getSource() {
        return this.source;
    }

    private class EnergyView
    extends EnergyStorageMutable {
        public EnergyView() {
            super(TileAutoChisel.this.energyStorage.getMaxEnergyStored(), 40, 0);
            this.setEnergyStored(TileAutoChisel.this.energyStorage.getEnergyStored());
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return TileAutoChisel.this.energyStorage.receiveEnergy(maxReceive, simulate);
        }
    }

    private static class EnergyStorageMutable
    extends EnergyStorage {
        public EnergyStorageMutable(int capacity, int maxReceive, int maxExtract) {
            super(capacity, maxReceive, maxExtract);
        }

        public void setEnergyStored(int energy) {
            this.energy = MathHelper.func_76125_a((int)energy, (int)0, (int)this.getMaxEnergyStored());
        }
    }

    private class ItemView
    implements IItemHandlerModifiable {
        private final IItemHandlerModifiable input;
        private final IItemHandlerModifiable output;

        ItemView(Direction side) {
            if (side == null || side.func_176740_k().func_200128_b()) {
                this.input = TileAutoChisel.this.inputInv;
                this.output = TileAutoChisel.this.outputInv;
            } else {
                this.input = this.output = TileAutoChisel.this.otherInv;
            }
        }

        public int getSlots() {
            return this.input == this.output ? this.input.getSlots() : this.input.getSlots() + this.output.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                if (slot < this.input.getSlots()) {
                    return this.input.getStackInSlot(slot);
                }
                return this.output.getStackInSlot(slot - this.input.getSlots());
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot >= 0 && slot < this.input.getSlots()) {
                return this.input.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= this.input.getSlots() && slot < this.getSlots()) {
                return this.output.extractItem(slot -= this.input.getSlots(), amount, simulate);
            }
            return ItemStack.field_190927_a;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot >= 0 && slot < this.getSlots()) {
                if (slot < this.input.getSlots()) {
                    this.input.setStackInSlot(slot, stack);
                } else {
                    this.output.setStackInSlot(slot - this.input.getSlots(), stack);
                }
            }
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot >= 0 && slot < this.getSlots()) {
                return slot < this.input.getSlots() && this.input.isItemValid(slot, stack);
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }
    }

    private class DirtyingStackHandler
    extends ItemStackHandler {
        DirtyingStackHandler() {
        }

        DirtyingStackHandler(int size) {
            super(size);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileAutoChisel.this.func_70296_d();
        }
    }
}

