/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.imc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.Chisel;
import team.chisel.api.IMC;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IVariationRegistry;

public class IMCHandler {
    public static final IMCHandler INSTANCE = new IMCHandler();
    public final Object2IntMap<String> imcCounts = new Object2IntOpenHashMap();
    private int order = 1000;
    private SetMultimap<String, String> deprecatedUses = HashMultimap.create();

    private IMCHandler() {
    }

    public void handleMessage(InterModComms.IMCMessage message) {
        for (IMC imc : IMC.values()) {
            if (!imc.key.equals(message.getMethod())) continue;
            this.handle(message, imc);
        }
    }

    private Pair<ItemStack, BlockState> parseNBT(CompoundNBT tag) {
        CompoundNBT stacktag = tag.func_74775_l("stack");
        String blockname = tag.func_74779_i("block");
        Preconditions.checkArgument((!stacktag.isEmpty() || !blockname.isEmpty() ? 1 : 0) != 0, (Object)"Must provide stack or blockstate.");
        ItemStack stack = null;
        if (!stacktag.isEmpty()) {
            stack = ItemStack.func_199557_a((CompoundNBT)stacktag);
        }
        Object state = null;
        if (!blockname.isEmpty()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockname));
            Preconditions.checkNotNull((Object)block, (String)"Could not find block %s in registry!", (Object)blockname);
        }
        return Pair.of((Object)stack, state);
    }

    private void handle(InterModComms.IMCMessage message, IMC type) {
        Set usedForMod;
        this.imcCounts.mergeInt((Object)message.getSenderModId(), 1, (i1, i2) -> i1 + i2);
        if (type.isDeprecated() && (usedForMod = this.deprecatedUses.get((Object)message.getSenderModId())).add(type.toString())) {
            Chisel.logger.warn("Mod {} is using deprecated IMC {}! This IMC type may be removed soon, please notify the author of this mod.", (Object)message.getSenderModId(), (Object)type);
        }
        IVariationRegistry reg = CarvingUtils.getChiselRegistry();
        Object data = null;
        Object resource = null;
        try {
            switch (type) {
                case ADD_VARIATION: {
                    CompoundNBT tag = (CompoundNBT)message.getMessageSupplier().get();
                    ResourceLocation group = new ResourceLocation(tag.func_74779_i("group"));
                    Preconditions.checkNotNull((Object)Strings.emptyToNull((String)group.func_110623_a()), (Object)"No group specified");
                    Pair<ItemStack, BlockState> variationdata = this.parseNBT(tag);
                    break;
                }
                case REMOVE_VARIATION: {
                    CompoundNBT tag = (CompoundNBT)message.getMessageSupplier().get();
                    String group = tag.func_74779_i("group");
                    Pair<ItemStack, BlockState> variationdata = this.parseNBT(tag);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid IMC constant! How...what...?");
                }
            }
        }
        catch (Exception e) {
            Object value = message.getMessageSupplier().get();
            Chisel.logger.error("Could not handle data {} for IMC type {}. This was sent from mod {}.\n!! This is a bug in that mod !!\nSwallowing error and continuing...", value, (Object)type.name(), (Object)message.getSenderModId());
            e.printStackTrace();
        }
    }
}

