/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.jei;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import team.chisel.Chisel;
import team.chisel.api.carving.CarvingUtils;

@ParametersAreNonnullByDefault
public class ChiselRecipeRegistryPlugin
implements IRecipeManagerPlugin {
    @Nonnull
    private static final List<ResourceLocation> POSSIBLE_CATEGORIES = ImmutableList.of((Object)VanillaRecipeCategoryUid.CRAFTING, (Object)VanillaRecipeCategoryUid.FURNACE, (Object)VanillaRecipeCategoryUid.INFORMATION);
    private IRecipeManager registry;
    private boolean preventRecursion;

    private List<ItemStack> getAlternateOutputs(IFocus<?> focus) {
        Object val = focus.getValue();
        if (!(val instanceof ItemStack)) {
            return Collections.emptyList();
        }
        ItemStack input = (ItemStack)val;
        List<ItemStack> chiselOptions = CarvingUtils.getChiselRegistry().getItemsForChiseling((ItemStack)focus.getValue());
        return chiselOptions.stream().filter(s -> !ItemStack.func_179545_c((ItemStack)s, (ItemStack)input)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> List<ResourceLocation> getRecipeCategoryUids(IFocus<V> focus) {
        if (focus.getMode() != IFocus.Mode.OUTPUT) {
            return Collections.emptyList();
        }
        List<ItemStack> alternates = this.getAlternateOutputs(focus);
        if (alternates.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            this.preventRecursion = true;
            List<ResourceLocation> list = this.registry.getRecipeCategories(POSSIBLE_CATEGORIES).stream().filter(c -> alternates.stream().flatMap(s -> this.registry.getRecipes(c, this.registry.createFocus(focus.getMode(), s)).stream()).count() != 0L).map(IRecipeCategory::getUid).collect(Collectors.toList());
            this.preventRecursion = false;
            return list;
        }
        catch (Throwable throwable) {
            try {
                this.preventRecursion = false;
                throw throwable;
            }
            catch (LinkageError | RuntimeException e) {
                Chisel.logger.error((Object)e);
                return Collections.emptyList();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        try {
            if (this.preventRecursion) {
                return Collections.emptyList();
            }
            if (focus.getMode() != IFocus.Mode.OUTPUT) {
                return Collections.emptyList();
            }
            if (!POSSIBLE_CATEGORIES.contains(recipeCategory.getUid())) {
                return Collections.emptyList();
            }
            try {
                this.preventRecursion = true;
                if (!this.registry.getRecipes(recipeCategory, focus).isEmpty()) {
                    List list = Collections.emptyList();
                    return list;
                }
                List list = this.getAlternateOutputs(focus).stream().map(alternate -> this.registry.createFocus(focus.getMode(), alternate)).flatMap(f -> this.registry.getRecipes(recipeCategory, f).stream()).collect(Collectors.toList());
                return list;
            }
            finally {
                this.preventRecursion = false;
            }
        }
        catch (LinkageError | RuntimeException e) {
            Chisel.logger.error((Object)e);
            return Collections.emptyList();
        }
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return Collections.emptyList();
    }

    void setRecipeRegistry(IRecipeManager recipeRegistry) {
        this.registry = recipeRegistry;
    }
}

