/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.repack.registrate.builders;

import net.minecraftforge.registries.IForgeRegistryEntry;
import team.chisel.repack.registrate.AbstractRegistrate;
import team.chisel.repack.registrate.providers.DataGenContext;
import team.chisel.repack.registrate.providers.ProviderType;
import team.chisel.repack.registrate.providers.RegistrateProvider;
import team.chisel.repack.registrate.util.entry.RegistryEntry;
import team.chisel.repack.registrate.util.nullness.NonNullBiConsumer;
import team.chisel.repack.registrate.util.nullness.NonNullConsumer;
import team.chisel.repack.registrate.util.nullness.NonNullFunction;
import team.chisel.repack.registrate.util.nullness.NonNullSupplier;

public interface Builder<R extends IForgeRegistryEntry<R>, T extends R, P, S extends Builder<R, T, P, S>>
extends NonNullSupplier<RegistryEntry<T>> {
    public RegistryEntry<T> register();

    public AbstractRegistrate<?> getOwner();

    public P getParent();

    public String getName();

    public Class<? super R> getRegistryType();

    @Override
    default public RegistryEntry<T> get() {
        return this.getOwner().get(this.getName(), this.getRegistryType());
    }

    default public T getEntry() {
        return ((RegistryEntry)this.get()).get();
    }

    public NonNullSupplier<T> asSupplier();

    default public <D extends RegistrateProvider> S setData(ProviderType<? extends D> type, NonNullBiConsumer<DataGenContext<R, T>, D> cons) {
        this.getOwner().setDataGenerator(this, type, prov -> cons.accept(DataGenContext.from(this, this.getRegistryType()), prov));
        return (S)this;
    }

    default public <D extends RegistrateProvider> S addMiscData(ProviderType<? extends D> type, NonNullConsumer<? extends D> cons) {
        this.getOwner().addDataGenerator(type, cons);
        return (S)this;
    }

    default public S onRegister(NonNullConsumer<? super T> callback) {
        this.getOwner().addRegisterCallback(this.getName(), this.getRegistryType(), callback);
        return (S)this;
    }

    default public <OR extends IForgeRegistryEntry<OR>> S onRegisterAfter(Class<? super OR> dependencyType, NonNullConsumer<? super T> callback) {
        return this.onRegister(e -> {
            if (this.getOwner().isRegistered(dependencyType)) {
                callback.accept(e);
            } else {
                this.getOwner().addRegisterCallback(dependencyType, () -> callback.accept(e));
            }
        });
    }

    default public <R2 extends IForgeRegistryEntry<R2>, T2 extends R2, P2, S2 extends Builder<R2, T2, P2, S2>> S2 transform(NonNullFunction<S, S2> func) {
        return (S2)((Builder)func.apply(this));
    }

    default public P build() {
        this.register();
        return this.getParent();
    }
}

