/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.line;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class LinedChiselMode
extends ForgeRegistryEntry<IChiselMode>
implements IChiselMode {
    private final int bitsPerSide;
    private final IFormattableTextComponent displayName;
    private final IFormattableTextComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    LinedChiselMode(int bitsPerSide, IFormattableTextComponent displayName, IFormattableTextComponent multiLineDisplayName, ResourceLocation iconName) {
        this.bitsPerSide = bitsPerSide;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()), Direction::func_176734_d, false);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                mutator.inWorldMutableStream().forEach(state -> {
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    }
                });
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m()), Function.identity(), true);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
            if (heldBlockState.isAir((IBlockReader)new SingleBlockBlockReader(heldBlockState), BlockPos.field_177992_a)) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a)).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.func_184812_l_()) {
                if (!playerEntity.func_184812_l_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a)).forEach(state -> state.overrideState(heldBlockState));
                }
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(PlayerEntity playerEntity, IChiselingContext context, Function<Direction, Vector3d> placementFacingAdapter, Function<Direction, Direction> iterationAdaptor, boolean airOnly) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vector3d hitBlockPosVector = Vector3d.func_237491_b_((Vector3i)new BlockPos(hitVector));
        Vector3d inBlockHitVector = hitVector.func_178788_d(hitBlockPosVector);
        Vector3d inBlockBitVector = inBlockHitVector.func_216372_d((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        Direction iterationDirection = iterationAdaptor.apply(blockRayTraceResult.func_216354_b());
        switch (iterationDirection) {
            case DOWN: {
                this.includeDownAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case UP: {
                this.includeUpAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case NORTH: {
                this.includeNorthAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case SOUTH: {
                this.includeSouthAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case WEST: {
                this.includeWestAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case EAST: {
                this.includeEastAxis(context, airOnly, hitBlockPosVector, inBlockBitVector);
            }
        }
        return Optional.empty();
    }

    private void includeDownAxis(IChiselingContext context, boolean airOnly, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int yOff = 0;
            while ((double)yOff < inBlockBitVector.func_82617_b()) {
                Vector3d targetBit = inBlockBitVector.func_178786_a(0.0, (double)yOff, 0.0);
                Vector3d inWorldOffset = this.clampVectorToBlock(targetBit.func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vector3d inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++yOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
                Vector3d targetBit;
                Vector3d inWorldOffset;
                Vector3d inWorldTarget;
                int yOff = 0;
                while ((double)yOff < inBlockBitVector.func_82617_b() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.func_178786_a((double)xOff, (double)yOff, (double)zOff)).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++yOff;
                }
            }
        }
    }

    private void includeUpAxis(IChiselingContext context, boolean airOnly, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int yOff = 0;
            while ((double)yOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.func_82617_b()) {
                Vector3d targetBit = inBlockBitVector.func_178786_a(0.0, (double)(-yOff), 0.0);
                Vector3d inWorldOffset = this.clampVectorToBlock(targetBit.func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vector3d inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++yOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
                Vector3d targetBit;
                Vector3d inWorldOffset;
                Vector3d inWorldTarget;
                int yOff = 0;
                while ((double)yOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.func_82617_b() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.func_178786_a((double)xOff, (double)(-yOff), (double)zOff)).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++yOff;
                }
            }
        }
    }

    private void includeNorthAxis(IChiselingContext context, boolean airOnly, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int zOff = 0;
            while ((double)zOff < inBlockBitVector.func_82616_c()) {
                Vector3d targetBit = inBlockBitVector.func_178786_a(0.0, 0.0, (double)zOff);
                Vector3d inWorldOffset = this.clampVectorToBlock(targetBit.func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vector3d inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++zOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vector3d targetBit;
                Vector3d inWorldOffset;
                Vector3d inWorldTarget;
                int zOff = 0;
                while ((double)zOff < inBlockBitVector.func_82616_c() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.func_178786_a((double)xOff, (double)yOff, (double)zOff)).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++zOff;
                }
            }
        }
    }

    private void includeSouthAxis(IChiselingContext context, boolean airOnly, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int zOff = 0;
            while ((double)zOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.func_82616_c()) {
                Vector3d targetBit = inBlockBitVector.func_178786_a(0.0, 0.0, (double)(-zOff));
                Vector3d inWorldOffset = this.clampVectorToBlock(targetBit.func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vector3d inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++zOff;
            }
            return;
        }
        for (int xOff = -this.bitsPerSide / 2; xOff < this.bitsPerSide / 2; ++xOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vector3d targetBit;
                Vector3d inWorldOffset;
                Vector3d inWorldTarget;
                int zOff = 0;
                while ((double)zOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.func_82616_c() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.func_178786_a((double)xOff, (double)yOff, (double)(-zOff))).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++zOff;
                }
            }
        }
    }

    private void includeWestAxis(IChiselingContext context, boolean airOnly, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int xOff = 0;
            while ((double)xOff < inBlockBitVector.func_82615_a()) {
                Vector3d targetBit = inBlockBitVector.func_178786_a((double)xOff, 0.0, 0.0);
                Vector3d inWorldOffset = this.clampVectorToBlock(targetBit.func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vector3d inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++xOff;
            }
            return;
        }
        for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vector3d targetBit;
                Vector3d inWorldOffset;
                Vector3d inWorldTarget;
                int xOff = 0;
                while ((double)xOff < inBlockBitVector.func_82615_a() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.func_178786_a((double)xOff, (double)yOff, (double)zOff)).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++xOff;
                }
            }
        }
    }

    private void includeEastAxis(IChiselingContext context, boolean airOnly, Vector3d hitBlockPosVector, Vector3d inBlockBitVector) {
        if (this.bitsPerSide == 1) {
            int xOff = 0;
            while ((double)xOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.func_82615_a()) {
                Vector3d targetBit = inBlockBitVector.func_178786_a((double)(-xOff), 0.0, 0.0);
                Vector3d inWorldOffset = this.clampVectorToBlock(targetBit.func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()));
                Vector3d inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset);
                if (!context.getInAreaTarget(inWorldTarget).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    return;
                }
                context.include(inWorldTarget);
                ++xOff;
            }
            return;
        }
        for (int zOff = -this.bitsPerSide / 2; zOff < this.bitsPerSide / 2; ++zOff) {
            for (int yOff = -this.bitsPerSide / 2; yOff < this.bitsPerSide / 2; ++yOff) {
                Vector3d targetBit;
                Vector3d inWorldOffset;
                Vector3d inWorldTarget;
                int xOff = 0;
                while ((double)xOff < (double)StateEntrySize.current().getBitsPerBlockSide() - inBlockBitVector.func_82615_a() && context.getInAreaTarget(inWorldTarget = hitBlockPosVector.func_178787_e(inWorldOffset = this.clampVectorToBlock((targetBit = inBlockBitVector.func_178786_a((double)(-xOff), (double)yOff, (double)zOff)).func_216372_d((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())))).map(state -> !state.getState().isAir((IBlockReader)new SingleBlockBlockReader(state.getState()), BlockPos.field_177992_a) ^ airOnly).orElse(airOnly).booleanValue()) {
                    context.include(inWorldTarget);
                    ++xOff;
                }
            }
        }
    }

    private Vector3d clampVectorToBlock(Vector3d v) {
        return new Vector3d(v.func_82615_a() < 0.0 ? 0.0 : (v.func_82615_a() >= 1.0 ? (double)0.999f : v.func_82615_a()), v.func_82617_b() < 0.0 ? 0.0 : (v.func_82617_b() >= 1.0 ? (double)0.999f : v.func_82617_b()), v.func_82616_c() < 0.0 ? 0.0 : (v.func_82616_c() >= 1.0 ? (double)0.999f : v.func_82616_c()));
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public ITextComponent getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.LINE);
    }
}

