/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.replace;

import com.google.common.collect.Maps;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.api.util.SingleBlockBlockReader;
import mod.chiselsandbits.registrars.ModMetadataKeys;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ReplaceChiselingMode
extends ForgeRegistryEntry<IChiselMode>
implements IChiselMode {
    private final IFormattableTextComponent displayName;
    private final IFormattableTextComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    public ReplaceChiselingMode(IFormattableTextComponent displayName, IFormattableTextComponent multiLineDisplayName, ResourceLocation iconName) {
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                BlockState heldBlockState = ItemStackUtils.getHeldBitBlockStateFromPlayer(playerEntity);
                if (heldBlockState.isAir((IBlockReader)new SingleBlockBlockReader(heldBlockState), BlockPos.field_177992_a)) {
                    ClickProcessingState clickProcessingState = ClickProcessingState.DEFAULT;
                    return clickProcessingState;
                }
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int missingBitCount = (int)mutator.stream().filter(filter).count();
                IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
                if (!playerEntity.func_184812_l_() && !playerBitInventory.canExtract(heldBlockState, missingBitCount)) {
                    ClickProcessingState clickProcessingState = ClickProcessingState.DEFAULT;
                    return clickProcessingState;
                }
                mutator.inWorldMutableStream().filter(filter).forEach(LamdbaExceptionUtils.rethrowConsumer(state -> {
                    BlockState currentState = state.getState();
                    if (context.tryDamageItem()) {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                    }
                    state.clear();
                    state.setState(heldBlockState);
                }));
                if (!playerEntity.func_184812_l_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return new ClickProcessingState(true, Event.Result.ALLOW);
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(PlayerEntity playerEntity, IChiselingContext context) {
        return this.onLeftClickBy(playerEntity, context);
    }

    @Override
    public void onStoppedRightClicking(PlayerEntity playerEntity, IChiselingContext context) {
    }

    @Override
    public boolean isStillValid(PlayerEntity playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        Optional validPositions = context.getMetadata((IMetadataKey)ModMetadataKeys.VALID_POSITIONS.get());
        Optional targetedSide = context.getMetadata((IMetadataKey)ModMetadataKeys.TARGETED_SIDE.get());
        Optional targetedBlockPos = context.getMetadata((IMetadataKey)ModMetadataKeys.TARGETED_BLOCK.get());
        if (!(validPositions.isPresent() && targetedSide.isPresent() && targetedBlockPos.isPresent())) {
            return false;
        }
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        if (blockRayTraceResult.func_216354_b() != targetedSide.get()) {
            return false;
        }
        Function<Direction, Vector3d> placementFacingAdapter = modeOfOperation == ChiselingOperation.CHISELING ? face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m()) : face -> Vector3d.func_237491_b_((Vector3i)face.func_176730_m());
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = new BlockPos(hitVector);
        Vector3d hitBlockPosVector = Vector3d.func_237491_b_((Vector3i)hitPos);
        Vector3d inBlockHitVector = hitVector.func_178788_d(hitBlockPosVector);
        Vector3i selectedPosition = new Vector3i(inBlockHitVector.func_82615_a() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82617_b() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82616_c() * (double)StateEntrySize.current().getBitsPerBlockSide());
        return ((Set)validPositions.get()).contains(selectedPosition) && hitPos.equals(targetedBlockPos.get());
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(PlayerEntity playerEntity, IChiselingContext context) {
        RayTraceResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.BLOCK || !(rayTraceResult instanceof BlockRayTraceResult)) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        Function<Direction, Vector3d> placementFacingAdapter = face -> Vector3d.func_237491_b_((Vector3i)face.func_176734_d().func_176730_m());
        BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTraceResult;
        Vector3d hitVector = blockRayTraceResult.func_216347_e().func_178787_e(placementFacingAdapter.apply(blockRayTraceResult.func_216354_b()).func_216372_d((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        BlockPos hitPos = new BlockPos(hitVector);
        Vector3d hitBlockPosVector = Vector3d.func_237491_b_((Vector3i)hitPos);
        Vector3d inBlockHitVector = hitVector.func_178788_d(hitBlockPosVector);
        LinkedList<Vector3i> toProcess = new LinkedList<Vector3i>();
        IWorldAreaMutator worldAccessor = IMutatorFactory.getInstance().in(context.getWorld(), hitPos);
        HashSet validPositions = new HashSet();
        Vector3i selectedPosition = new Vector3i(inBlockHitVector.func_82615_a() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82617_b() * (double)StateEntrySize.current().getBitsPerBlockSide(), inBlockHitVector.func_82616_c() * (double)StateEntrySize.current().getBitsPerBlockSide());
        toProcess.addLast(selectedPosition);
        Vector3d selectedInBlockPosition = Vector3d.func_237491_b_((Vector3i)selectedPosition).func_216369_h(StateEntrySize.current().getSizePerBitScalingVector());
        Optional<IStateEntryInfo> targetedInfo = worldAccessor.getInAreaTarget(selectedInBlockPosition);
        if (!targetedInfo.isPresent()) {
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        worldAccessor.stream().filter(state -> state.getState().equals(((IStateEntryInfo)targetedInfo.get()).getState())).map(state -> state.getStartPoint().func_216369_h(StateEntrySize.current().getBitsPerBlockSideScalingVector())).map(position -> new Vector3i(position.func_82615_a(), position.func_82617_b(), position.func_82616_c())).forEach(validPositions::add);
        context.include(hitPos, Vector3d.field_186680_a);
        context.include(hitPos, new Vector3d(0.9999, 0.9999, 0.9999));
        context.setStateFilter(accessor -> new SelectedBitStateFilter(validPositions));
        context.setMetadata((IMetadataKey)ModMetadataKeys.VALID_POSITIONS.get(), validPositions);
        context.setMetadata((IMetadataKey)ModMetadataKeys.TARGETED_SIDE.get(), blockRayTraceResult.func_216354_b());
        context.setMetadata((IMetadataKey)ModMetadataKeys.TARGETED_BLOCK.get(), hitPos);
        return Optional.empty();
    }

    @Override
    public boolean requiresPlaceableEditStack() {
        return true;
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.displayName;
    }

    @Override
    public ITextComponent getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    private static final class SelectedBitStateFilter
    implements Predicate<IStateEntryInfo> {
        private final Set<Vector3i> validPositions;

        public SelectedBitStateFilter(Set<Vector3i> validPositions) {
            this.validPositions = validPositions;
        }

        @Override
        public boolean test(IStateEntryInfo iStateEntryInfo) {
            Vector3i position = new Vector3i(iStateEntryInfo.getStartPoint().func_82615_a() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().func_82617_b() * (double)StateEntrySize.current().getBitsPerBlockSide(), iStateEntryInfo.getStartPoint().func_82616_c() * (double)StateEntrySize.current().getBitsPerBlockSide());
            return this.validPositions.contains(position);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SelectedBitStateFilter)) {
                return false;
            }
            SelectedBitStateFilter that = (SelectedBitStateFilter)o;
            return this.validPositions.equals(that.validPositions);
        }

        public int hashCode() {
            return this.validPositions.hashCode();
        }

        public String toString() {
            return "SelectedBitStateFilter{validPositions=" + this.validPositions + '}';
        }
    }
}

