/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.base;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;

public abstract class BaseBakedPerspectiveModel
implements IBakedModel {
    protected static final Random RANDOM = new Random();
    private static final TransformationMatrix ground;
    private static final TransformationMatrix gui;
    private static final TransformationMatrix fixed;
    private static final TransformationMatrix firstPerson_righthand;
    private static final TransformationMatrix firstPerson_lefthand;
    private static final TransformationMatrix thirdPerson_righthand;
    private static final TransformationMatrix thirdPerson_lefthand;

    private static TransformationMatrix getMatrix(float transX, float transY, float transZ, float rotX, float rotY, float rotZ, float scaleXYZ) {
        Vector3f translation = new Vector3f(transX, transY, transZ);
        Vector3f scale = new Vector3f(scaleXYZ, scaleXYZ, scaleXYZ);
        Quaternion rotation = new Quaternion(rotX, rotY, rotZ, true);
        return new TransformationMatrix(translation, rotation, scale, null);
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
        switch (cameraTransformType) {
            case FIRST_PERSON_LEFT_HAND: {
                firstPerson_lefthand.push(mat);
                return this;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                firstPerson_righthand.push(mat);
                return this;
            }
            case THIRD_PERSON_LEFT_HAND: {
                thirdPerson_lefthand.push(mat);
                return this;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                thirdPerson_righthand.push(mat);
            }
            case FIXED: {
                fixed.push(mat);
                return this;
            }
            case GROUND: {
                ground.push(mat);
                return this;
            }
            case GUI: {
                gui.push(mat);
                return this;
            }
        }
        fixed.push(mat);
        return this;
    }

    static {
        gui = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f);
        ground = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.1875f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f);
        fixed = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f);
        thirdPerson_lefthand = thirdPerson_righthand = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.15625f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        firstPerson_righthand = firstPerson_lefthand = BaseBakedPerspectiveModel.getMatrix(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f);
    }
}

