/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.bit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.client.events.TickHandler;
import mod.chiselsandbits.client.model.baked.bit.BitBlockBakedModel;
import mod.chiselsandbits.client.model.baked.simple.NullBakedModel;
import mod.chiselsandbits.item.bit.BitItem;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.NonNullList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BitBlockBakedModelManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final BitBlockBakedModelManager INSTANCE = new BitBlockBakedModelManager();
    private final Cache<BlockState, IBakedModel> modelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<BlockState, IBakedModel> largeModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final NonNullList<ItemStack> alternativeStacks = NonNullList.func_191196_a();

    private BitBlockBakedModelManager() {
    }

    public static BitBlockBakedModelManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.modelCache.asMap().clear();
        this.largeModelCache.asMap().clear();
    }

    public IBakedModel get(ItemStack stack) {
        return this.get(stack, !Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_197986_j() && Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d() || Minecraft.func_71410_x().func_228018_at_() != null && Screen.func_231173_s_());
    }

    public IBakedModel get(ItemStack stack, boolean large) {
        if (!(stack.func_77973_b() instanceof IBitItem)) {
            LOGGER.warn("Tried to get bit item model for non bit item");
            return NullBakedModel.instance;
        }
        return this.get(((IBitItem)stack.func_77973_b()).getBitState(stack), large);
    }

    public IBakedModel get(BlockState state, boolean large) {
        if (state == Blocks.field_150350_a.func_176223_P() || state == null) {
            int alternativeIndex;
            ItemStack stack;
            if (this.alternativeStacks.isEmpty()) {
                ((BitItem)ModItems.ITEM_BLOCK_BIT.get()).func_150895_a(Objects.requireNonNull(((BitItem)ModItems.ITEM_BLOCK_BIT.get()).func_77640_w()), this.alternativeStacks);
            }
            if (!((stack = (ItemStack)this.alternativeStacks.get(alternativeIndex = (int)(Math.floor((double)TickHandler.getClientTicks() / 20.0) % (double)this.alternativeStacks.size()))).func_77973_b() instanceof IBitItem)) {
                throw new IllegalStateException("BitItem returned none bit item stack!");
            }
            state = ((IBitItem)stack.func_77973_b()).getBitState(stack);
        }
        Cache<BlockState, IBakedModel> target = large ? this.largeModelCache : this.modelCache;
        BlockState workingState = state;
        try {
            return (IBakedModel)target.get((Object)state, () -> {
                if (large) {
                    BlockState lookupState = workingState;
                    if (workingState.func_177230_c() instanceof FlowingFluidBlock) {
                        lookupState = (BlockState)workingState.func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(15));
                    }
                    return Minecraft.func_71410_x().func_175602_ab().func_184389_a(lookupState);
                }
                return new BitBlockBakedModel(workingState);
            });
        }
        catch (ExecutionException e) {
            LOGGER.warn("Failed to get a model for a bit: " + state + " the model calculation got aborted.", (Throwable)e);
            return NullBakedModel.instance;
        }
    }
}

