/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.events;

import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.click.ILeftClickControllingItem;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.profiling.ProfilingManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LeftClickEventHandler {
    @SubscribeEvent
    public static void onPlayerInteractLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() instanceof ILeftClickControllingItem) {
            try (IProfilerSection ignored = ProfilingManager.getInstance().withSection("Left click processing");){
                ILeftClickControllingItem leftClickControllingItem = (ILeftClickControllingItem)itemStack.func_77973_b();
                if (!leftClickControllingItem.canUse(event.getPlayer())) {
                    event.setCanceled(true);
                    event.setUseItem(Event.Result.DENY);
                    return;
                }
                ClickProcessingState processingState = leftClickControllingItem.handleLeftClickProcessing(event.getPlayer(), event.getHand(), event.getPos(), event.getFace(), new ClickProcessingState(event.isCanceled(), event.getUseItem()));
                if (processingState.shouldCancel()) {
                    event.setCanceled(true);
                }
                event.setUseItem(processingState.getNextState());
            }
        }
    }
}

