/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.List;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitStorageBlockItem
extends BlockItem {
    public BitStorageBlockItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null) {
            return;
        }
        FluidStack fluid = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
        if (fluid.isEmpty()) {
            Configuration.getInstance().getCommon().helpText(LocalStrings.HelpBitTankEmpty, tooltip, new Object[0]);
        } else {
            Configuration.getInstance().getCommon().helpText(LocalStrings.HelpBitTankFilled, tooltip, new TranslationTextComponent(fluid.getTranslationKey()), String.valueOf((int)Math.floor((double)fluid.getAmount() * 4.096)));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerItemStack(stack, 1000);
    }

    protected boolean func_195943_a(@NotNull BlockPos pos, @NotNull World worldIn, @Nullable PlayerEntity player, @NotNull ItemStack stack, @NotNull BlockState state) {
        super.func_195943_a(pos, worldIn, player, stack, state);
        if (worldIn.field_72995_K) {
            return false;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return false;
        }
        BitStorageBlockEntity tileEntityBitStorage = (BitStorageBlockEntity)tileEntity;
        tileEntityBitStorage.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(t -> t.fill(stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(s -> s.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY), IFluidHandler.FluidAction.EXECUTE));
        return true;
    }
}

