/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item;

import java.util.Collection;
import java.util.List;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.exceptions.SealingNotSupportedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.pattern.IMultiUsePatternItem;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.item.multistate.SingleBlockMultiStateItemStack;
import mod.chiselsandbits.multistate.snapshot.EmptySnapshot;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.registrars.ModPatternPlacementTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleUsePatternItem
extends Item
implements IPatternItem {
    public SingleUsePatternItem(Item.Properties builder) {
        super(builder);
    }

    public ITextComponent getHighlightTip(ItemStack item, ITextComponent displayName) {
        if (!item.func_196082_o().func_74764_b("highlight")) {
            return super.getHighlightTip(item, displayName);
        }
        String highlightTextJson = item.func_196082_o().func_74779_i("highlight");
        return ITextComponent.Serializer.func_240643_a_((String)highlightTextJson).func_240699_a_(TextFormatting.RED);
    }

    @Override
    @NotNull
    public IMultiStateItemStack createItemStack(ItemStack stack) {
        if (stack.func_196082_o().isEmpty()) {
            return EmptySnapshot.Stack.INSTANCE;
        }
        return new SingleBlockMultiStateItemStack(stack);
    }

    @NotNull
    public ActionResultType func_195939_a(@NotNull ItemUseContext context) {
        IMultiStateItemStack contents = this.createItemStack(context.func_195996_i());
        if (contents.getStatistics().isEmpty()) {
            if (context.func_195999_j() == null) {
                return ActionResultType.FAIL;
            }
            if (!context.func_195999_j().func_184812_l_()) {
                return ActionResultType.FAIL;
            }
            if (!context.func_195999_j().func_213453_ef()) {
                return ActionResultType.FAIL;
            }
            IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().in((IWorld)context.func_195991_k(), context.func_195995_a());
            ItemStack snapshotPatternStack = areaMutator.createSnapshot().toItemStack().toPatternStack();
            context.func_195996_i().func_77982_d(snapshotPatternStack.func_196082_o().func_74737_b());
            return ActionResultType.SUCCESS;
        }
        return this.tryPlace(new BlockItemUseContext(context));
    }

    @NotNull
    public ActionResultType tryPlace(@NotNull BlockItemUseContext context) {
        if (context.func_195999_j() == null) {
            return ActionResultType.FAIL;
        }
        IMultiStateItemStack source = this.createItemStack(context.func_195996_i());
        IMultiStateSnapshot sourceSnapshot = source.createSnapshot();
        PlacementResult resultType = this.getMode(context.func_195996_i()).performPlacement(sourceSnapshot, context, false);
        ItemStack resultingStack = context.func_195996_i().func_77946_l();
        if (!resultType.isSuccess()) {
            resultingStack.func_196082_o().func_74778_a("highlight", ITextComponent.Serializer.func_150696_a((ITextComponent)resultType.getFailureMessage()));
            resultingStack.func_196082_o().func_74772_a("highlightStartTime", context.func_195999_j().field_70170_p.func_82737_E());
        } else {
            resultingStack.func_196082_o().func_82580_o("highlight");
            resultingStack.func_196082_o().func_82580_o("highlightStartTime");
        }
        context.func_195999_j().func_184611_a(context.func_221531_n(), resultingStack);
        return resultType.isSuccess() ? this.determineSuccessResult(context, resultingStack) : ActionResultType.FAIL;
    }

    protected ActionResultType determineSuccessResult(BlockItemUseContext context, ItemStack stack) {
        if (context.func_195999_j() != null && context.func_195999_j().func_184812_l_()) {
            return ActionResultType.SUCCESS;
        }
        stack.func_190918_g(1);
        return ActionResultType.CONSUME;
    }

    @Override
    @NotNull
    public ItemStack seal(@NotNull ItemStack source) throws SealingNotSupportedException {
        if (source.func_77973_b() == this) {
            if (!(source.func_77973_b() instanceof IMultiUsePatternItem)) {
                ItemStack seal = new ItemStack((IItemProvider)ModItems.MULTI_USE_PATTERN_ITEM.get());
                seal.func_77982_d(source.func_196082_o().func_74737_b());
                return seal;
            }
            throw new SealingNotSupportedException();
        }
        return source;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        IPatternPlacementType mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((ITextComponent)LocalStrings.PatternItemTooltipModeGrouped.getText(((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((ITextComponent)LocalStrings.PatternItemTooltipModeSimple.getText(mode.getDisplayName()));
        }
        if (Minecraft.func_71410_x().func_228018_at_() != null && Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new StringTextComponent("        "));
            tooltip.add((ITextComponent)new StringTextComponent("        "));
            Configuration.getInstance().getCommon().helpText(LocalStrings.HelpSimplePattern, tooltip, new Object[0]);
        }
    }

    @Override
    @NotNull
    public IPatternPlacementType getMode(ItemStack stack) {
        return (IPatternPlacementType)ModPatternPlacementTypes.REGISTRY_SUPPLIER.get().getValue(stack.func_196082_o().func_74764_b("mode") ? new ResourceLocation(stack.func_196082_o().func_74779_i("mode")) : ModPatternPlacementTypes.PLACEMENT.getId());
    }

    @Override
    public void setMode(ItemStack stack, IPatternPlacementType mode) {
        stack.func_196082_o().func_74778_a("mode", mode.getRegistryName().toString());
    }

    @Override
    @NotNull
    public Collection<IPatternPlacementType> getPossibleModes() {
        return ModPatternPlacementTypes.REGISTRY_SUPPLIER.get().getValues();
    }
}

