/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.bit;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.ILocalChiselingContextCache;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.client.chiseling.preview.render.IChiselContextPreviewRendererRegistry;
import mod.chiselsandbits.api.config.Configuration;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.documentation.IDocumentableItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.chiseling.ChiselingManager;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitItem
extends Item
implements IChiselingItem,
IBitItem,
IDocumentableItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LEGACY_BLOCK_STATE_ID_KEY = "id";
    private final List<ItemStack> availableBitStacks = Lists.newLinkedList();
    private final ThreadLocal<Boolean> threadLocalBitMergeOperationInProgress = ThreadLocal.withInitial(() -> false);

    public BitItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ClickProcessingState handleLeftClickProcessing(PlayerEntity playerEntity, Hand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        return this.handleClickProcessing(playerEntity, hand, currentState, ChiselingOperation.CHISELING, IChiselMode::onLeftClickBy);
    }

    @Override
    public boolean canUse(PlayerEntity playerEntity) {
        return ChiselingManager.getInstance().canChisel(playerEntity);
    }

    @Override
    @NotNull
    public IChiselMode getMode(ItemStack stack) {
        CompoundNBT stackNbt = stack.func_196082_o();
        if (stackNbt.func_74764_b("chiselMode")) {
            String chiselModeName = stackNbt.func_74779_i("chiselMode");
            try {
                IChiselMode registryMode = (IChiselMode)IChiselMode.getRegistry().getValue(new ResourceLocation(chiselModeName));
                if (registryMode == null) {
                    return IChiselMode.getDefaultMode();
                }
                return registryMode;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid chisel mode: %s", chiselModeName));
                this.setMode(stack, IChiselMode.getDefaultMode());
            }
        }
        return IChiselMode.getDefaultMode();
    }

    @NotNull
    public ITextComponent func_200295_i(@NotNull ItemStack stack) {
        BlockState containedStack = this.getBitState(stack);
        Block block = containedStack.func_177230_c();
        ITextComponent stateName = block.func_199767_j().func_200295_i(new ItemStack((IItemProvider)block));
        if (block instanceof FlowingFluidBlock) {
            FlowingFluidBlock flowingFluidBlock = (FlowingFluidBlock)block;
            stateName = new TranslationTextComponent(flowingFluidBlock.getFluid().getAttributes().getTranslationKey());
        }
        return new TranslationTextComponent(this.func_77667_c(stack), new Object[]{stateName});
    }

    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        IChiselMode mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((ITextComponent)TranslationUtils.build("chiselmode.mode_grouped", ((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((ITextComponent)TranslationUtils.build("chiselmode.mode", mode.getDisplayName()));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void setMode(ItemStack stack, IChiselMode mode) {
        if (mode == null) {
            return;
        }
        stack.func_196082_o().func_74778_a("chiselMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IChiselMode> getPossibleModes() {
        return IChiselMode.getRegistry().getValues().stream().sorted(Comparator.comparing(arg_0 -> ((ForgeRegistry)((ForgeRegistry)IChiselMode.getRegistry())).getID(arg_0))).collect(Collectors.toList());
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(PlayerEntity playerEntity, Hand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        return this.handleClickProcessing(playerEntity, hand, currentState, ChiselingOperation.PLACING, IChiselMode::onRightClickBy);
    }

    private ClickProcessingState handleClickProcessing(PlayerEntity playerEntity, Hand hand, ClickProcessingState currentState, ChiselingOperation modeOfOperation, ChiselModeInteractionCallback callback) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != this) {
            return currentState;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.func_77973_b();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        IChiselingContext context = IChiselingManager.getInstance().getOrCreateContext(playerEntity, chiselMode, modeOfOperation, false, itemStack);
        ClickProcessingState resultState = callback.run(chiselMode, playerEntity, context);
        if (context.isComplete()) {
            playerEntity.func_184811_cZ().func_185145_a((Item)this, 3);
        }
        return resultState;
    }

    @Override
    public BlockState getBitState(ItemStack stack) {
        if (!stack.func_196082_o().func_74764_b("blockState")) {
            if (!stack.func_196082_o().func_74764_b(LEGACY_BLOCK_STATE_ID_KEY)) {
                return Blocks.field_150350_a.func_176223_P();
            }
            BlockState blockState = IBlockStateIdManager.getInstance().getBlockStateFrom(stack.func_196082_o().func_74762_e(LEGACY_BLOCK_STATE_ID_KEY));
            stack.func_196082_o().func_82580_o(LEGACY_BLOCK_STATE_ID_KEY);
            stack.func_196082_o().func_218657_a("blockState", (INBT)NBTUtil.func_190009_a((BlockState)blockState));
        }
        return NBTUtil.func_190008_d((CompoundNBT)stack.func_190925_c("blockState"));
    }

    @Override
    public void onMergeOperationWithBagBeginning() {
        this.threadLocalBitMergeOperationInProgress.set(true);
    }

    @Override
    public void onMergeOperationWithBagEnding() {
        this.threadLocalBitMergeOperationInProgress.set(false);
    }

    public int getItemStackLimit(ItemStack stack) {
        if (this.threadLocalBitMergeOperationInProgress.get().booleanValue()) {
            return (Integer)Configuration.getInstance().getServer().bagStackSize.get();
        }
        return super.getItemStackLimit(stack);
    }

    @Override
    public boolean shouldDrawDefaultHighlight(@NotNull PlayerEntity playerEntity) {
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != this) {
            return true;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.func_77973_b();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext context = potentiallyExistingContext.get();
            if (context.getMutator().isPresent()) {
                return false;
            }
            IChiselingContext currentContextSnapshot = context.createSnapshot();
            if (currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING) {
                chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            } else {
                chiselMode.onRightClickBy(playerEntity, currentContextSnapshot);
            }
            return !currentContextSnapshot.getMutator().isPresent();
        }
        Optional<IChiselingContext> localCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (localCachedContext.isPresent()) {
            IChiselingContext context = localCachedContext.get();
            if (context.getMode() == chiselMode && context.getMutator().isPresent()) {
                return false;
            }
            return !context.getMutator().isPresent();
        }
        IChiselingContext context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, context);
        if (context.getMutator().isPresent()) {
            return false;
        }
        chiselMode.onRightClickBy(playerEntity, context);
        return !context.getMutator().isPresent();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHighlight(PlayerEntity playerEntity, WorldRenderer worldRenderer, MatrixStack matrixStack, float partialTicks, Matrix4f projectionMatrix, long finishTimeNano) {
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.func_190926_b() || itemStack.func_77973_b() != this) {
            return;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.func_77973_b();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode);
        Optional<IChiselingContext> potentialChiselingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        Optional<IChiselingContext> potentialPlacingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext currentContextSnapshot = potentiallyExistingContext.get().createSnapshot();
            if (currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING) {
                chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            } else {
                chiselMode.onRightClickBy(playerEntity, currentContextSnapshot);
            }
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, currentContextSnapshot);
            return;
        }
        if (potentialChiselingContext.isPresent() && potentialChiselingContext.get().getMode() == chiselMode && chiselMode.isStillValid(playerEntity, potentialChiselingContext.get(), ChiselingOperation.CHISELING)) {
            IChiselingContext chiselingContext = potentialChiselingContext.get();
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, chiselingContext);
            if (potentialPlacingContext.isPresent() && potentialPlacingContext.get().getMode() == chiselMode && chiselMode.isStillValid(playerEntity, potentialPlacingContext.get(), ChiselingOperation.PLACING)) {
                IChiselingContext placingContext = potentialPlacingContext.get();
                IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, placingContext);
            }
            return;
        }
        if (potentialPlacingContext.isPresent() && potentialPlacingContext.get().getMode() == chiselMode && chiselMode.isStillValid(playerEntity, potentialPlacingContext.get(), ChiselingOperation.PLACING)) {
            IChiselingContext context = potentialPlacingContext.get();
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, context);
            return;
        }
        IChiselingContext chiselingContext = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        IChiselingContext placingContext = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.PLACING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, chiselingContext);
        chiselMode.onRightClickBy(playerEntity, placingContext);
        RenderSystem.disableDepthTest();
        if (chiselingContext.getMutator().isPresent()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, chiselingContext);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, chiselingContext);
        }
        if (placingContext.getMutator().isPresent()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, placingContext);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.PLACING, placingContext);
        }
        Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(ModRenderTypes.MEASUREMENT_LINES.get());
        RenderSystem.enableDepthTest();
    }

    @Override
    public boolean isDamageableDuringChiseling() {
        return false;
    }

    public void func_150895_a(@Nullable ItemGroup group, @NotNull NonNullList<ItemStack> items) {
        if (group == null || this.func_77640_w() != group) {
            return;
        }
        if (this.availableBitStacks.isEmpty()) {
            ForgeRegistries.BLOCKS.getValues().forEach(block -> {
                if (IEligibilityManager.getInstance().canBeChiseled((Block)block)) {
                    BlockState blockState = block.func_176223_P();
                    ItemStack resultStack = IBitItemManager.getInstance().create(blockState);
                    if (!resultStack.func_190926_b() && resultStack.func_77973_b() instanceof IBitItem) {
                        this.availableBitStacks.add(resultStack);
                    }
                }
            });
            this.availableBitStacks.sort(Comparator.comparing(stack -> {
                if (!(stack.func_77973_b() instanceof IBitItem)) {
                    throw new IllegalStateException("Stack did not contain a bit item.");
                }
                return IBlockStateIdManager.getInstance().getIdFrom(((IBitItem)stack.func_77973_b()).getBitState((ItemStack)stack));
            }));
        }
        items.addAll(this.availableBitStacks);
    }

    @Override
    public Map<String, ItemStack> getDocumentableInstances(Item item) {
        return ForgeRegistries.BLOCKS.getValues().stream().map(block -> {
            if (IEligibilityManager.getInstance().canBeChiseled((Block)block)) {
                BlockState blockState = block.func_176223_P();
                return IBitItemManager.getInstance().create(blockState);
            }
            return ItemStack.field_190927_a;
        }).filter(stack -> !stack.func_190926_b()).collect(Collectors.toMap(stack -> "bit_" + this.getBitState((ItemStack)stack).func_177230_c().getRegistryName().toString().replace(":", "_"), Function.identity()));
    }

    @FunctionalInterface
    private static interface ChiselModeInteractionCallback {
        public ClickProcessingState run(IChiselMode var1, PlayerEntity var2, IChiselingContext var3);
    }
}

