/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.legacy.serialization.blob;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class BitStream {
    int offset = 0;
    int bit = 0;
    int firstLiveInt = -1;
    int lastLiveInt = -1;
    int currentInt = 0;
    int intOffset = 0;
    IntBuffer output;
    ByteBuffer bytes;

    public BitStream() {
        this.bytes = ByteBuffer.allocate(250);
        this.output = this.bytes.asIntBuffer();
    }

    private BitStream(int byteOffset, ByteBuffer wrap) {
        this.intOffset = byteOffset / 4;
        this.bytes = wrap;
        this.output = this.bytes.asIntBuffer();
        this.currentInt = this.hasInt() ? this.output.get(0) : 0;
    }

    public static BitStream valueOf(int byteOffset, ByteBuffer wrap) {
        return new BitStream(byteOffset, wrap);
    }

    public void reset() {
        this.offset = 0;
        this.bit = 0;
        this.firstLiveInt = -1;
        this.lastLiveInt = -1;
        this.output.put(0, 0);
        this.currentInt = 0;
        this.intOffset = 0;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        this.output.put(this.offset, this.currentInt);
        o.write(this.bytes.array(), 0, (this.lastLiveInt + 1) * 4);
        return o.toByteArray();
    }

    public boolean get() {
        boolean result;
        boolean bl = result = (this.currentInt & 1 << this.bit) != 0;
        if (++this.bit >= 32) {
            ++this.offset;
            this.bit = 0;
            this.currentInt = this.hasInt() ? this.output.get(this.offset - this.intOffset) : 0;
        }
        return result;
    }

    private boolean hasInt() {
        return this.output.capacity() > this.offset - this.intOffset && this.offset - this.intOffset >= 0;
    }

    public void add(boolean b) {
        if (b) {
            this.currentInt |= 1 << this.bit;
            this.lastLiveInt = this.offset;
            if (this.firstLiveInt == -1) {
                this.firstLiveInt = this.offset;
            }
        }
        if (++this.bit >= 32) {
            this.output.put(this.offset, this.currentInt);
            ++this.offset;
            this.bit = 0;
            this.currentInt = 0;
            if (this.output.capacity() <= this.offset) {
                ByteBuffer ibytes = ByteBuffer.allocate(this.bytes.limit() + 248);
                IntBuffer ioutput = ibytes.asIntBuffer();
                System.arraycopy(this.bytes.array(), 0, ibytes.array(), 0, this.bytes.capacity());
                this.bytes = ibytes;
                this.output = ioutput;
            }
            this.output.put(this.offset, 0);
        }
    }

    public int byteOffset() {
        return Math.max(this.firstLiveInt * 4, 0);
    }
}

