/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.materials;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.block.material.Material;

public class MaterialManager {
    private static final MaterialManager INSTANCE = new MaterialManager();
    private final Map<Material, String> materialNames = Maps.newHashMap();
    private final Multimap<String, Material> knownMaterials = HashMultimap.create();
    private final Map<Material, Material> materialRemapping = Maps.newHashMap();

    private MaterialManager() {
        this.registerMapping("wood", Material.field_151575_d);
        this.registerMapping("rock", Material.field_151576_e);
        this.registerMapping("iron", Material.field_151573_f);
        this.registerMapping("cloth", Material.field_151593_r);
        this.registerMapping("ice", Material.field_151588_w);
        this.registerMapping("packed_ice", Material.field_151598_x);
        this.registerMapping("clay", Material.field_151571_B);
        this.registerMapping("glass", Material.field_151592_s);
        this.registerMapping("sand", Material.field_151595_p);
        this.registerMapping("ground", Material.field_151578_c);
        this.registerMapping("grass", Material.field_151577_b);
        this.registerMapping("snow", Material.field_151596_z);
        this.registerMapping("fluid", Material.field_151586_h);
        this.registerMapping("leaves", Material.field_151584_j);
        this.registerMapping("plant", Material.field_151585_k);
        this.registerMapping("wool", Material.field_151580_n);
        this.registerMapping("nether_wood", Material.field_237214_y_);
        this.registerRemapping(Material.field_151583_m, Material.field_151571_B);
        this.registerRemapping(Material.field_151574_g, Material.field_151573_f);
        this.registerRemapping(Material.field_151572_C, Material.field_151585_k);
        this.registerRemapping(Material.field_151570_A, Material.field_151585_k);
        this.registerRemapping(Material.field_151589_v, Material.field_151576_e);
        this.registerRemapping(Material.field_151569_G, Material.field_151585_k);
        this.registerRemapping(Material.field_151590_u, Material.field_151576_e);
        this.registerRemapping(Material.field_151587_i, Material.field_151586_h);
    }

    public void registerMapping(String name, Material material) {
        if (this.knownMaterials.containsKey((Object)name)) {
            throw new IllegalArgumentException(String.format("The material name: %s is already registered!", name));
        }
        this.knownMaterials.put((Object)name, (Object)material);
        this.materialNames.put(material, name);
    }

    public void registerRemapping(Material material, Material target) {
        if (this.materialRemapping.containsKey(material)) {
            throw new IllegalArgumentException("Can not remap a material twice!");
        }
        if (this.knownMaterials.containsValue((Object)material)) {
            throw new IllegalArgumentException("Can not remap a material which is registered as a working material.");
        }
        if (!this.knownMaterials.containsValue((Object)target)) {
            throw new IllegalArgumentException("Can not remap a material to a material which is not registered as a working material.");
        }
        this.materialRemapping.put(material, target);
    }

    public static MaterialManager getInstance() {
        return INSTANCE;
    }

    public Multimap<String, Material> getKnownMaterials() {
        return this.knownMaterials;
    }

    public Map<Material, String> getMaterialNames() {
        return this.materialNames;
    }

    public Material remapMaterialIfNeeded(Material material) {
        return this.materialRemapping.getOrDefault(material, material);
    }
}

