/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network.packets;

import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.network.packets.ModPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class RequestChangeTrackerOperation
extends ModPacket {
    private boolean redo;

    public RequestChangeTrackerOperation(PacketBuffer byteBuf) {
        this.readPayload(byteBuf);
    }

    public RequestChangeTrackerOperation(boolean redo) {
        this.redo = redo;
    }

    @Override
    public void writePayload(PacketBuffer buffer) {
        buffer.writeBoolean(this.redo);
    }

    @Override
    public void readPayload(PacketBuffer buffer) {
        this.redo = buffer.readBoolean();
    }

    @Override
    public void server(ServerPlayerEntity playerEntity) {
        IChangeTracker tracker = IChangeTrackerManager.getInstance().getChangeTracker((PlayerEntity)playerEntity);
        if (this.redo) {
            if (!tracker.canRedo((PlayerEntity)playerEntity)) {
                playerEntity.func_145747_a((ITextComponent)LocalStrings.CanNotRedo.getText().func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
                return;
            }
            try {
                tracker.redo((PlayerEntity)playerEntity);
                playerEntity.func_145747_a((ITextComponent)LocalStrings.RedoSuccessful.getText().func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
            }
            catch (IllegalChangeAttempt e) {
                playerEntity.func_145747_a((ITextComponent)LocalStrings.CanNotRedo.getText().func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return;
        }
        if (!tracker.canUndo((PlayerEntity)playerEntity)) {
            playerEntity.func_145747_a((ITextComponent)LocalStrings.CanNotUndo.getText().func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return;
        }
        try {
            tracker.undo((PlayerEntity)playerEntity);
            playerEntity.func_145747_a((ITextComponent)LocalStrings.UndoSuccessful.getText().func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
        }
        catch (IllegalChangeAttempt e) {
            playerEntity.func_145747_a((ITextComponent)LocalStrings.CanNotUndo.getText().func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
    }
}

