/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.profiling;

import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.FilledProfileResult;
import net.minecraft.profiler.IProfileResult;

public class CandBProfilingResult
implements IProfilerResult {
    private final IProfileResult innerResult;

    public CandBProfilingResult(IProfileResult innerResult) {
        this.innerResult = innerResult;
    }

    @Override
    public void writeToFile(File file) {
        this.innerResult.func_219919_a(file);
    }

    @Override
    public void writeAsResponse(Consumer<String> lineConsumer) {
        if (!(this.innerResult instanceof FilledProfileResult)) {
            return;
        }
        FilledProfileResult filledProfileResult = (FilledProfileResult)this.innerResult;
        lineConsumer.accept("Results:");
        this.writeDatapointsAsResponse("root", arg_0 -> ((FilledProfileResult)filledProfileResult).func_219917_a(arg_0), lineConsumer, " ");
    }

    private void writeDatapointsAsResponse(String name, Function<String, List<DataPoint>> producer, Consumer<String> lineConsumer, String indent) {
        List<DataPoint> dataPoints = producer.apply(name);
        dataPoints.forEach(dataPoint -> {
            lineConsumer.accept(String.format("%s> %s: %s (%s)", indent, dataPoint.field_219945_c.substring(dataPoint.field_219945_c.lastIndexOf(30) + 1), dataPoint.field_219943_a, dataPoint.field_219944_b));
            if (!dataPoint.field_219945_c.equals(name)) {
                this.writeDatapointsAsResponse(name + '\u001e' + dataPoint.field_219945_c, producer, lineConsumer, indent + " ");
            }
        });
    }
}

