/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registrars;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.chiseling.metadata.SimpleMetadataKey;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

public final class ModMetadataKeys {
    private static final DeferredRegister<IMetadataKey<?>> KEY_REGISTRAR = DeferredRegister.create(IMetadataKey.class, (String)"chiselsandbits");
    public static final Supplier<IForgeRegistry<IMetadataKey<?>>> REGISTRY_SUPPLIER = KEY_REGISTRAR.makeRegistry("metadata_key", () -> new RegistryBuilder().allowModification().disableOverrides().disableSaving());
    public static final RegistryObject<IMetadataKey<Vector3d>> ANCHOR = KEY_REGISTRAR.register("anchor", () -> new SimpleMetadataKey<Vector3d>(){

        @Override
        public Vector3d snapshot(Vector3d value) {
            return new Vector3d(value.func_82615_a(), value.func_82617_b(), value.func_82616_c());
        }
    });
    public static final RegistryObject<IMetadataKey<Vector3d>> END_POINT = KEY_REGISTRAR.register("endpoint", () -> new SimpleMetadataKey<Vector3d>(){

        @Override
        public Vector3d snapshot(Vector3d value) {
            return new Vector3d(value.func_82615_a(), value.func_82617_b(), value.func_82616_c());
        }
    });
    public static final RegistryObject<IMetadataKey<Direction>> TARGETED_SIDE = KEY_REGISTRAR.register("targeted_side", () -> new SimpleMetadataKey<Direction>(){

        @Override
        public Direction snapshot(Direction value) {
            return value;
        }
    });
    public static final RegistryObject<IMetadataKey<Set<Vector3i>>> VALID_POSITIONS = KEY_REGISTRAR.register("valid_positions", () -> new SimpleMetadataKey<Set<Vector3i>>(){

        @Override
        public Set<Vector3i> snapshot(Set<Vector3i> value) {
            return value.stream().map(val -> new Vector3i(val.func_177958_n(), val.func_177956_o(), val.func_177952_p())).collect(Collectors.toSet());
        }
    });
    public static final RegistryObject<IMetadataKey<BlockPos>> TARGETED_BLOCK = KEY_REGISTRAR.register("targeted_block", () -> new SimpleMetadataKey<BlockPos>(){

        @Override
        public BlockPos snapshot(BlockPos value) {
            return value;
        }
    });

    private ModMetadataKeys() {
        throw new IllegalStateException("Can not instantiate an instance of: ModMetadataKeys. This is a utility class");
    }

    public static void onModConstruction() {
        KEY_REGISTRAR.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

