/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.MathUtil;
import mod.chiselsandbits.utils.DirectionUtils;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import org.jetbrains.annotations.NotNull;

public class AABBUtils {
    private AABBUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: AABBUtils. This is a utility class");
    }

    public static boolean areBoxesNeighbors(@NotNull AxisAlignedBB l, @NotNull AxisAlignedBB r, @NotNull Direction direction) {
        double endOfL = AABBUtils.getDirectionalValue(l, direction);
        double startOfR = AABBUtils.getDirectionalValue(r, direction.func_176734_d());
        if (!MathUtil.almostEqual(endOfL, startOfR)) {
            return false;
        }
        List<Direction> remainingDirectionsToCheck = DirectionUtils.getNotOnAxisOf(direction);
        Map valuesOfL = remainingDirectionsToCheck.stream().collect(Collectors.toMap(Function.identity(), d -> AABBUtils.getDirectionalValue(l, d)));
        Map valuesOfR = remainingDirectionsToCheck.stream().collect(Collectors.toMap(Function.identity(), d -> AABBUtils.getDirectionalValue(r, d)));
        return remainingDirectionsToCheck.stream().allMatch(d -> MathUtil.almostEqual((Number)valuesOfL.get(d), (Number)valuesOfR.get(d)));
    }

    public static double getDirectionalValue(@NotNull AxisAlignedBB bb, @NotNull Direction direction) {
        return direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? bb.func_197742_b(direction.func_176740_k()) : bb.func_197745_a(direction.func_176740_k());
    }
}

