/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.cultivation.init;

import cofh.lib.block.impl.CakeBlockCoFH;
import cofh.lib.block.impl.DirectionalBlock4Way;
import cofh.lib.block.impl.SoilBlock;
import cofh.lib.block.impl.TilledSoilBlock;
import cofh.lib.block.impl.crops.AttachedStemBlockCoFH;
import cofh.lib.block.impl.crops.CropsBlockMushroom;
import cofh.lib.block.impl.crops.StemBlockCoFH;
import cofh.lib.util.constants.Constants;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.util.RegistrationHelper;
import cofh.thermal.cultivation.block.FlaxCrop;
import cofh.thermal.cultivation.block.FrostMelonBlock;
import cofh.thermal.cultivation.init.TCulFoods;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FireBlock;
import net.minecraft.block.HayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.ToolType;

public class TCulBlocks {
    private TCulBlocks() {
    }

    public static void register() {
        TCulBlocks.registerPlants();
        TCulBlocks.registerFoods();
        TCulBlocks.registerStorage();
        TCulBlocks.registerMisc();
    }

    public static void setup() {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get(RegistrationHelper.block((String)"barley")), 60, 20);
        fire.func_180686_a((Block)ThermalCore.BLOCKS.get(RegistrationHelper.block((String)"corn")), 60, 20);
    }

    private static void registerPlants() {
        RegistrationHelper.registerAnnual((String)"barley");
        RegistrationHelper.registerTallAnnual((String)"corn");
        TCulBlocks.registerFlax("flax");
        RegistrationHelper.registerAnnual((String)"onion");
        RegistrationHelper.registerAnnual((String)"radish");
        RegistrationHelper.registerAnnual((String)"rice");
        RegistrationHelper.registerAnnual((String)"sadiroot");
        RegistrationHelper.registerAnnual((String)"spinach");
        RegistrationHelper.registerPerennial((String)"bell_pepper");
        RegistrationHelper.registerPerennial((String)"eggplant");
        RegistrationHelper.registerPerennial((String)"green_bean");
        RegistrationHelper.registerPerennial((String)"peanut");
        RegistrationHelper.registerPerennial((String)"strawberry");
        RegistrationHelper.registerPerennial((String)"tomato");
        RegistrationHelper.registerPerennial((String)"coffee", (int)6);
        RegistrationHelper.registerPerennial((String)"tea");
        ThermalCore.BLOCKS.register("glowstone_mushroom", () -> new CropsBlockMushroom(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222474_u).func_235838_a_(state -> (Integer)state.func_177229_b((Property)Constants.AGE_0_4) == 4 ? 12 : 0)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.spores((String)"glowstone_mushroom"))));
        TCulBlocks.registerMushroom("gunpowder_mushroom");
        ThermalCore.BLOCKS.register("redstone_mushroom", () -> new CropsBlockMushroom(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222474_u).func_235838_a_(state -> (Integer)state.func_177229_b((Property)Constants.AGE_0_4) == 4 ? 7 : 0)){

            public boolean func_149744_f(BlockState state) {
                return true;
            }

            public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
                return (Integer)blockState.func_177229_b((Property)Constants.AGE_0_4) == 4 ? 7 : 0;
            }
        }.seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.spores((String)"redstone_mushroom"))));
        TCulBlocks.registerMushroom("slime_mushroom");
        RegistrationHelper.registerBlock((String)"frost_melon", () -> new FrostMelonBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151572_C, (MaterialColor)MaterialColor.field_151679_y).func_200944_c().func_200943_b(1.0f).harvestTool(ToolType.AXE).func_200947_a(SoundType.field_185856_i)), (Rarity)Rarity.UNCOMMON);
        RegistrationHelper.registerBlockOnly((String)"frost_melon_stem", () -> new StemBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200944_c().func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_185848_a)).crop((Supplier)ThermalCore.BLOCKS.getSup("frost_melon")).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)"frost_melon"))));
        RegistrationHelper.registerBlockOnly((String)"frost_melon_stem_attached", () -> new AttachedStemBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200943_b(0.0f).func_200947_a(SoundType.field_222473_t)).crop((Supplier)ThermalCore.BLOCKS.getSup("frost_melon")).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)"frost_melon"))));
    }

    private static void registerFoods() {
        RegistrationHelper.registerBlock((String)"chocolate_cake", () -> new CakeBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151568_F).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g), TCulFoods.CHOCOLATE_CAKE));
        RegistrationHelper.registerBlock((String)"spice_cake", () -> new CakeBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151568_F).func_200943_b(0.5f).func_200947_a(SoundType.field_185854_g), TCulFoods.SPICE_CAKE));
    }

    private static void registerStorage() {
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"barley"), () -> new HayBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151647_F).func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.HOE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"corn"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151673_t).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"flax"), () -> new HayBlock(AbstractBlock.Properties.func_200949_a((Material)Material.field_151577_b, (MaterialColor)MaterialColor.field_151678_z).func_200943_b(0.5f).func_200947_a(SoundType.field_185850_c).harvestTool(ToolType.HOE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"onion"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193561_M).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"radish"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193559_aa).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"sadiroot"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193574_Z).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"spinach"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"bell_pepper"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193559_aa).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"eggplant"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193571_W).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"green_bean"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"hops"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151651_C).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"strawberry"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_193559_aa).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"tomato"), () -> new Block(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151645_D).func_200943_b(1.5f).func_200947_a(SoundType.field_222470_q).harvestTool(ToolType.AXE)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"rice"), () -> new DirectionalBlock4Way(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_193561_M).func_200943_b(0.5f).func_200947_a(SoundType.field_235588_J_)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"coffee"), () -> new DirectionalBlock4Way(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_193559_aa).func_200943_b(0.5f).func_200947_a(SoundType.field_235588_J_)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"peanut"), () -> new DirectionalBlock4Way(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_193573_Y).func_200943_b(0.5f).func_200947_a(SoundType.field_235588_J_)));
        RegistrationHelper.registerBlock((String)RegistrationHelper.block((String)"tea"), () -> new DirectionalBlock4Way(AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)MaterialColor.field_193574_Z).func_200943_b(0.5f).func_200947_a(SoundType.field_235588_J_)));
    }

    private static void registerMisc() {
        RegistrationHelper.registerBlock((String)"phytosoil", () -> new SoilBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200944_c().func_200943_b(0.8f).harvestTool(ToolType.SHOVEL).func_200947_a(SoundType.field_185849_b).func_235838_a_(state -> (Integer)state.func_177229_b((Property)Constants.CHARGED) > 0 ? 7 : 0)));
        RegistrationHelper.registerBlock((String)"phytosoil_tilled", () -> new TilledSoilBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151578_c).func_200944_c().func_200943_b(0.8f).harvestTool(ToolType.SHOVEL).func_200947_a(SoundType.field_185849_b).func_235838_a_(state -> (Integer)state.func_177229_b((Property)Constants.CHARGED) > 0 ? 7 : 0)).dirt((Supplier)ThermalCore.BLOCKS.getSup("phytosoil")));
    }

    public static void registerFlax(String id) {
        ThermalCore.BLOCKS.register(id, () -> new FlaxCrop(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds((String)id))));
    }

    public static void registerMushroom(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockMushroom(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222474_u)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.spores((String)id))));
    }
}

