/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.BlockBreakingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockBreakingMovementBehaviour
extends MovementBehaviour {
    @Override
    public void startMoving(MovementContext context) {
        if (context.world.field_72995_K) {
            return;
        }
        context.data.func_74768_a("BreakerId", -BlockBreakingKineticTileEntity.NEXT_BREAKER_ID.incrementAndGet());
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        World world = context.world;
        BlockState stateVisited = world.func_180495_p(pos);
        if (!stateVisited.func_215686_e((IBlockReader)world, pos)) {
            this.damageEntities(context, pos, world);
        }
        if (world.field_72995_K) {
            return;
        }
        if (!this.canBreak(world, pos, stateVisited)) {
            return;
        }
        context.data.func_218657_a("BreakingPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        context.stall = true;
    }

    public void damageEntities(MovementContext context, BlockPos pos, World world) {
        DamageSource damageSource = this.getDamageSource();
        if (damageSource == null && !this.throwsEntities()) {
            return;
        }
        block0: for (Entity entity : world.func_217357_a(Entity.class, new AxisAlignedBB(pos))) {
            if (entity instanceof ItemEntity || entity instanceof AbstractContraptionEntity) continue;
            if (entity instanceof AbstractMinecartEntity) {
                for (Entity passenger : entity.func_184182_bu()) {
                    if (!(passenger instanceof AbstractContraptionEntity) || ((AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                    continue block0;
                }
            }
            if (damageSource != null && !world.field_72995_K) {
                float damage = (float)MathHelper.func_151237_a((double)(6.0 * Math.pow(context.relativeMotion.func_72433_c(), 0.4) + 1.0), (double)2.0, (double)10.0);
                entity.func_70097_a(damageSource, damage);
            }
            if (!this.throwsEntities() || world.field_72995_K != entity instanceof PlayerEntity) continue;
            Vector3d motionBoost = context.motion.func_72441_c(0.0, context.motion.func_72433_c() / 4.0, 0.0);
            int maxBoost = 4;
            if (motionBoost.func_72433_c() > (double)maxBoost) {
                motionBoost = motionBoost.func_178788_d(motionBoost.func_72432_b().func_186678_a(motionBoost.func_72433_c() - (double)maxBoost));
            }
            entity.func_213317_d(entity.func_213322_ci().func_178787_e(motionBoost));
            entity.field_70133_I = true;
        }
    }

    protected DamageSource getDamageSource() {
        return null;
    }

    protected boolean throwsEntities() {
        return this.getDamageSource() != null;
    }

    @Override
    public void stopMoving(MovementContext context) {
        CompoundNBT data = context.data;
        if (context.world.field_72995_K) {
            return;
        }
        if (!data.func_74764_b("BreakingPos")) {
            return;
        }
        World world = context.world;
        int id = data.func_74762_e("BreakerId");
        BlockPos breakingPos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("BreakingPos"));
        data.func_82580_o("Progress");
        data.func_82580_o("TicksUntilNextProgress");
        data.func_82580_o("BreakingPos");
        context.stall = false;
        world.func_175715_c(id, breakingPos, -1);
    }

    @Override
    public void tick(MovementContext context) {
        this.tickBreaker(context);
        CompoundNBT data = context.data;
        if (!data.func_74764_b("WaitingTicks")) {
            return;
        }
        int waitingTicks = data.func_74762_e("WaitingTicks");
        if (waitingTicks-- > 0) {
            data.func_74768_a("WaitingTicks", waitingTicks);
            context.stall = true;
            return;
        }
        BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("LastPos"));
        data.func_82580_o("WaitingTicks");
        data.func_82580_o("LastPos");
        context.stall = false;
        this.visitNewPosition(context, pos);
    }

    public void tickBreaker(MovementContext context) {
        CompoundNBT data = context.data;
        if (context.world.field_72995_K) {
            return;
        }
        if (!data.func_74764_b("BreakingPos")) {
            return;
        }
        if (context.relativeMotion.equals((Object)Vector3d.field_186680_a)) {
            context.stall = false;
            return;
        }
        int ticksUntilNextProgress = data.func_74762_e("TicksUntilNextProgress");
        if (ticksUntilNextProgress-- > 0) {
            data.func_74768_a("TicksUntilNextProgress", ticksUntilNextProgress);
            return;
        }
        World world = context.world;
        BlockPos breakingPos = NBTUtil.func_186861_c((CompoundNBT)data.func_74775_l("BreakingPos"));
        int destroyProgress = data.func_74762_e("Progress");
        int id = data.func_74762_e("BreakerId");
        BlockState stateToBreak = world.func_180495_p(breakingPos);
        float blockHardness = stateToBreak.func_185887_b((IBlockReader)world, breakingPos);
        if (!this.canBreak(world, breakingPos, stateToBreak)) {
            if (destroyProgress != 0) {
                destroyProgress = 0;
                data.func_82580_o("Progress");
                data.func_82580_o("TicksUntilNextProgress");
                data.func_82580_o("BreakingPos");
                world.func_175715_c(id, breakingPos, -1);
            }
            context.stall = false;
            return;
        }
        float breakSpeed = MathHelper.func_76131_a((float)(Math.abs(context.getAnimationSpeed()) / 500.0f), (float)0.0078125f, (float)16.0f);
        destroyProgress += MathHelper.func_76125_a((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - destroyProgress));
        world.func_184133_a(null, breakingPos, stateToBreak.func_215695_r().func_185846_f(), SoundCategory.NEUTRAL, 0.25f, 1.0f);
        if (destroyProgress >= 10) {
            world.func_175715_c(id, breakingPos, -1);
            BlockPos ogPos = breakingPos;
            BlockState stateAbove = world.func_180495_p(breakingPos.func_177984_a());
            while (stateAbove.func_177230_c() instanceof FallingBlock) {
                breakingPos = breakingPos.func_177984_a();
                stateAbove = world.func_180495_p(breakingPos.func_177984_a());
            }
            stateToBreak = world.func_180495_p(breakingPos);
            context.stall = false;
            if (this.shouldDestroyStartBlock(stateToBreak)) {
                BlockHelper.destroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (ItemStack)stack));
            }
            this.onBlockBroken(context, ogPos, stateToBreak);
            ticksUntilNextProgress = -1;
            data.func_82580_o("Progress");
            data.func_82580_o("TicksUntilNextProgress");
            data.func_82580_o("BreakingPos");
            return;
        }
        ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        world.func_175715_c(id, breakingPos, destroyProgress);
        data.func_74768_a("TicksUntilNextProgress", ticksUntilNextProgress);
        data.func_74768_a("Progress", destroyProgress);
    }

    protected boolean shouldDestroyStartBlock(BlockState stateToBreak) {
        return true;
    }

    public boolean canBreak(World world, BlockPos breakingPos, BlockState state) {
        float blockHardness = state.func_185887_b((IBlockReader)world, breakingPos);
        return BlockBreakingKineticTileEntity.isBreakable(state, blockHardness);
    }

    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        if (!(brokenState.func_177230_c() instanceof FallingBlock)) {
            return;
        }
        CompoundNBT data = context.data;
        data.func_74768_a("WaitingTicks", 10);
        data.func_218657_a("LastPos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
        context.stall = true;
    }
}

