/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.mixer;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.components.mixer.MixingRecipe;
import com.simibubi.create.content.contraptions.components.press.MechanicalPressTileEntity;
import com.simibubi.create.content.contraptions.fluids.FluidFX;
import com.simibubi.create.content.contraptions.fluids.recipe.PotionMixingRecipeManager;
import com.simibubi.create.content.contraptions.processing.BasinOperatingTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.ITriggerable;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class MechanicalMixerTileEntity
extends BasinOperatingTileEntity {
    private static final Object shapelessOrMixingRecipesKey = new Object();
    public int runningTicks;
    public int processingTicks;
    public boolean running;

    public MechanicalMixerTileEntity(TileEntityType<? extends MechanicalMixerTileEntity> type) {
        super(type);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        float offset = 0.0f;
        if (this.running) {
            if (this.runningTicks < 20) {
                int localTick = this.runningTicks;
                float num = ((float)localTick + partialTicks) / 20.0f;
                num = (2.0f - MathHelper.func_76134_b((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            } else if (this.runningTicks <= 20) {
                offset = 1.0f;
            } else {
                int localTick = 40 - this.runningTicks;
                float num = ((float)localTick - partialTicks) / 20.0f;
                num = (2.0f - MathHelper.func_76134_b((float)((float)((double)num * Math.PI)))) / 2.0f;
                offset = num - 0.5f;
            }
        }
        return offset + 0.4375f;
    }

    public float getRenderedHeadRotationSpeed(float partialTicks) {
        float speed = this.getSpeed();
        if (this.running) {
            if (this.runningTicks < 15) {
                return speed;
            }
            if (this.runningTicks <= 20) {
                return speed * 2.0f;
            }
            return speed;
        }
        return speed / 2.0f;
    }

    @Override
    public AxisAlignedBB makeRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_72321_a(0.0, -1.5, 0.0);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.running = compound.func_74767_n("Running");
        this.runningTicks = compound.func_74762_e("Ticks");
        super.fromTag(state, compound, clientPacket);
        if (clientPacket && this.func_145830_o()) {
            this.getBasin().ifPresent(bte -> bte.setAreFluidsMoving(this.running && this.runningTicks <= 20));
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("Running", this.running);
        compound.func_74768_a("Ticks", this.runningTicks);
        super.write(compound, clientPacket);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.runningTicks >= 40) {
            this.running = false;
            this.runningTicks = 0;
            this.basinChecker.scheduleUpdate();
            return;
        }
        float speed = Math.abs(this.getSpeed());
        if (this.running && this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K && this.runningTicks == 20) {
                this.renderParticles();
            }
            if ((!this.field_145850_b.field_72995_K || this.isVirtual()) && this.runningTicks == 20) {
                if (this.processingTicks < 0) {
                    Couple<SmartFluidTankBehaviour> tanks;
                    this.processingTicks = MathHelper.func_76125_a((int)(MathHelper.func_151239_c((int)((int)(512.0f / speed))) * 15 + 1), (int)1, (int)512);
                    Optional<BasinTileEntity> basin = this.getBasin();
                    if (!(!basin.isPresent() || ((SmartFluidTankBehaviour)(tanks = basin.get().getTanks()).getFirst()).isEmpty() && ((SmartFluidTankBehaviour)tanks.getSecond()).isEmpty())) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_203282_jc, SoundCategory.BLOCKS, 0.75f, speed < 65.0f ? 0.75f : 1.5f);
                    }
                } else {
                    --this.processingTicks;
                    if (this.processingTicks == 0) {
                        ++this.runningTicks;
                        this.processingTicks = -1;
                        this.applyBasinRecipe();
                        this.sendData();
                    }
                }
            }
            if (this.runningTicks != 20) {
                ++this.runningTicks;
            }
        }
    }

    public void renderParticles() {
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.isPresent() || this.field_145850_b == null) {
            return;
        }
        for (SmartInventory inv : basin.get().getInvs()) {
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (stackInSlot.func_190926_b()) continue;
                ItemParticleData data = new ItemParticleData(ParticleTypes.field_197591_B, stackInSlot);
                this.spillParticle((IParticleData)data);
            }
        }
        for (SmartFluidTankBehaviour behaviour : basin.get().getTanks()) {
            if (behaviour == null) continue;
            for (SmartFluidTankBehaviour.TankSegment tankSegment : behaviour.getTanks()) {
                if (tankSegment.isEmpty(0.0f)) continue;
                this.spillParticle(FluidFX.getFluidParticle(tankSegment.getRenderedFluid()));
            }
        }
    }

    protected void spillParticle(IParticleData data) {
        float angle = this.field_145850_b.field_73012_v.nextFloat() * 360.0f;
        Vector3d offset = new Vector3d(0.0, 0.0, 0.25);
        offset = VecHelper.rotate(offset, angle, Direction.Axis.Y);
        Vector3d target = VecHelper.rotate(offset, this.getSpeed() > 0.0f ? 25.0 : -25.0, Direction.Axis.Y).func_72441_c(0.0, 0.25, 0.0);
        Vector3d center = offset.func_178787_e(VecHelper.getCenterOf((Vector3i)this.field_174879_c));
        target = VecHelper.offsetRandomly(target.func_178788_d(offset), this.field_145850_b.field_73012_v, 0.0078125f);
        this.field_145850_b.func_195594_a(data, center.field_72450_a, center.field_72448_b - 1.75, center.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c);
    }

    @Override
    protected List<IRecipe<?>> getMatchingRecipes() {
        List<IRecipe<?>> matchingRecipes = super.getMatchingRecipes();
        Optional<BasinTileEntity> basin = this.getBasin();
        if (!basin.isPresent()) {
            return matchingRecipes;
        }
        IItemHandler availableItems = (IItemHandler)basin.get().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
        if (availableItems == null) {
            return matchingRecipes;
        }
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            List<MixingRecipe> list;
            ItemStack stack = availableItems.getStackInSlot(i);
            if (stack.func_190926_b() || (list = PotionMixingRecipeManager.ALL.get(stack.func_77973_b())) == null) continue;
            for (MixingRecipe mixingRecipe : list) {
                if (!this.matchBasinRecipe(mixingRecipe)) continue;
                matchingRecipes.add(mixingRecipe);
            }
        }
        return matchingRecipes;
    }

    @Override
    protected <C extends IInventory> boolean matchStaticFilters(IRecipe<C> r) {
        return r.func_199559_b() == IRecipeSerializer.field_222158_b && (Boolean)AllConfigs.SERVER.recipes.allowShapelessInMixer.get() != false && r.func_192400_c().size() > 1 && !MechanicalPressTileEntity.canCompress(r) || r.func_222127_g() == AllRecipeTypes.MIXING.getType();
    }

    @Override
    public void startProcessingBasin() {
        if (this.running && this.runningTicks <= 20) {
            return;
        }
        super.startProcessingBasin();
        this.running = true;
        this.runningTicks = 0;
    }

    @Override
    public boolean continueWithPreviousRecipe() {
        this.runningTicks = 20;
        return true;
    }

    @Override
    protected void onBasinRemoved() {
        if (!this.running) {
            return;
        }
        this.runningTicks = 40;
        this.running = false;
    }

    @Override
    protected Object getRecipeCacheKey() {
        return shapelessOrMixingRecipesKey;
    }

    @Override
    protected boolean isRunning() {
        return this.running;
    }

    @Override
    protected Optional<ITriggerable> getProcessedRecipeTrigger() {
        return Optional.of(AllTriggers.MIXER_MIX);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        boolean slow;
        super.tickAudio();
        boolean bl = slow = Math.abs(this.getSpeed()) < 65.0f;
        if (slow && AnimationTickHolder.getTicks() % 2 == 0) {
            return;
        }
        if (this.runningTicks == 20) {
            AllSoundEvents.MIXING.playAt(this.field_145850_b, this.field_174879_c, 0.75f, 1.0f, true);
        }
    }
}

