/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.contraptions.base.IRotate;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionCollider;
import com.simibubi.create.content.contraptions.components.structureMovement.ControlledContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.DirectionalExtenderScrollOptionSlot;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.LinearActuatorTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonContraption;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class MechanicalPistonTileEntity
extends LinearActuatorTileEntity {
    protected boolean hadCollisionWithOtherPiston;
    protected int extensionLength;

    public MechanicalPistonTileEntity(TileEntityType<? extends MechanicalPistonTileEntity> type) {
        super(type);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        this.extensionLength = compound.func_74762_e("ExtensionLength");
        super.fromTag(state, compound, clientPacket);
    }

    @Override
    protected void write(CompoundNBT tag, boolean clientPacket) {
        tag.func_74768_a("ExtensionLength", this.extensionLength);
        super.write(tag, clientPacket);
    }

    @Override
    public void assemble() throws AssemblyException {
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof MechanicalPistonBlock)) {
            return;
        }
        Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        PistonContraption contraption = new PistonContraption(direction, this.getMovementSpeed() < 0.0f);
        if (!contraption.assemble(this.field_145850_b, this.field_174879_c)) {
            return;
        }
        Direction positive = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)direction.func_176740_k());
        Direction movementDirection = this.getSpeed() > 0.0f ^ direction.func_176740_k() != Direction.Axis.Z ? positive : positive.func_176734_d();
        BlockPos anchor = contraption.anchor.func_177967_a(direction, contraption.initialExtensionProgress);
        if (ContraptionCollider.isCollidingWithWorld(this.field_145850_b, contraption, anchor.func_177972_a(movementDirection), movementDirection)) {
            return;
        }
        this.extensionLength = contraption.extensionLength;
        float resultingOffset = (float)contraption.initialExtensionProgress + Math.signum(this.getMovementSpeed()) * 0.5f;
        if (resultingOffset <= 0.0f || resultingOffset >= (float)this.extensionLength) {
            return;
        }
        this.running = true;
        this.offset = contraption.initialExtensionProgress;
        this.sendData();
        this.clientOffsetDiff = 0.0f;
        BlockPos startPos = BlockPos.field_177992_a.func_177967_a(direction, contraption.initialExtensionProgress);
        contraption.removeBlocksFromWorld(this.field_145850_b, startPos);
        this.movedContraption = ControlledContraptionEntity.create(this.func_145831_w(), this, contraption);
        this.applyContraptionPosition();
        this.forceMove = true;
        this.field_145850_b.func_217376_c((Entity)this.movedContraption);
        AllSoundEvents.CONTRAPTION_ASSEMBLE.playOnServer(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void disassemble() {
        if (!this.running && this.movedContraption == null) {
            return;
        }
        if (!this.field_145846_f) {
            this.func_145831_w().func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.EXTENDED)), 19);
        }
        if (this.movedContraption != null) {
            this.applyContraptionPosition();
            this.movedContraption.disassemble();
            AllSoundEvents.CONTRAPTION_DISASSEMBLE.playOnServer(this.field_145850_b, this.field_174879_c);
        }
        this.running = false;
        this.movedContraption = null;
        this.sendData();
        if (this.field_145846_f) {
            ((MechanicalPistonBlock)AllBlocks.MECHANICAL_PISTON.get()).func_176208_a(this.field_145850_b, this.field_174879_c, this.func_195044_w(), null);
        }
    }

    @Override
    public void collided() {
        super.collided();
        if (!this.running && this.getMovementSpeed() > 0.0f) {
            this.assembleNextTick = true;
        }
    }

    @Override
    public float getMovementSpeed() {
        float movementSpeed = MathHelper.func_76131_a((float)MechanicalPistonTileEntity.convertToLinear(this.getSpeed()), (float)-0.49f, (float)0.49f);
        if (this.field_145850_b.field_72995_K) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        Direction pistonDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        int movementModifier = pistonDirection.func_176743_c().func_179524_a() * (pistonDirection.func_176740_k() == Direction.Axis.Z ? -1 : 1);
        movementSpeed = movementSpeed * (float)(-movementModifier) + this.clientOffsetDiff / 2.0f;
        int extensionRange = this.getExtensionRange();
        movementSpeed = MathHelper.func_76131_a((float)movementSpeed, (float)(0.0f - this.offset), (float)((float)extensionRange - this.offset));
        return movementSpeed;
    }

    @Override
    protected int getExtensionRange() {
        return this.extensionLength;
    }

    @Override
    protected void visitNewPosition() {
    }

    @Override
    protected Vector3d toMotionVector(float speed) {
        Direction pistonDirection = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        return Vector3d.func_237491_b_((Vector3i)pistonDirection.func_176730_m()).func_186678_a((double)speed);
    }

    @Override
    protected Vector3d toPosition(float offset) {
        Vector3d position = Vector3d.func_237491_b_((Vector3i)((Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176730_m()).func_186678_a((double)offset);
        return position.func_178787_e(Vector3d.func_237491_b_((Vector3i)this.movedContraption.getContraption().anchor));
    }

    @Override
    protected ValueBoxTransform getMovementModeSlot() {
        return new DirectionalExtenderScrollOptionSlot((state, d) -> {
            Direction.Axis axis = d.func_176740_k();
            Direction.Axis extensionAxis = ((Direction)state.func_177229_b((Property)MechanicalPistonBlock.FACING)).func_176740_k();
            Direction.Axis shaftAxis = ((IRotate)state.func_177230_c()).getRotationAxis((BlockState)state);
            return extensionAxis != axis && shaftAxis != axis;
        });
    }

    @Override
    protected int getInitialOffset() {
        return this.movedContraption == null ? 0 : ((PistonContraption)this.movedContraption.getContraption()).initialExtensionProgress;
    }
}

