/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.piston;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.components.structureMovement.AssemblyException;
import com.simibubi.create.content.contraptions.components.structureMovement.BlockMovementChecks;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionLighter;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionType;
import com.simibubi.create.content.contraptions.components.structureMovement.TranslatingContraption;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonExtensionPoleBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.PistonLighter;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.Queue;
import net.minecraft.block.BlockState;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

public class PistonContraption
extends TranslatingContraption {
    protected int extensionLength;
    protected int initialExtensionProgress;
    protected Direction orientation;
    private AxisAlignedBB pistonExtensionCollisionBox;
    private boolean retract;

    @Override
    protected ContraptionType getType() {
        return ContraptionType.PISTON;
    }

    public PistonContraption() {
    }

    public PistonContraption(Direction direction, boolean retract) {
        this.orientation = direction;
        this.retract = retract;
    }

    @Override
    public boolean assemble(World world, BlockPos pos) throws AssemblyException {
        if (!this.collectExtensions(world, pos, this.orientation)) {
            return false;
        }
        int count = this.blocks.size();
        if (!this.searchMovedStructure(world, this.anchor, this.retract ? this.orientation.func_176734_d() : this.orientation)) {
            return false;
        }
        this.bounds = this.blocks.size() == count ? this.pistonExtensionCollisionBox : this.bounds.func_111270_a(this.pistonExtensionCollisionBox);
        this.startMoving(world);
        return true;
    }

    private boolean collectExtensions(World world, BlockPos pos, Direction direction) throws AssemblyException {
        ArrayList<Template.BlockInfo> poles = new ArrayList<Template.BlockInfo>();
        BlockPos actualStart = pos;
        BlockState nextBlock = world.func_180495_p(actualStart.func_177972_a(direction));
        int extensionsInFront = 0;
        BlockState blockState = world.func_180495_p(pos);
        boolean sticky = MechanicalPistonBlock.isStickyPiston(blockState);
        if (!MechanicalPistonBlock.isPiston(blockState)) {
            return false;
        }
        if (blockState.func_177229_b(MechanicalPistonBlock.STATE) == MechanicalPistonBlock.PistonState.EXTENDED) {
            while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.func_176740_k()) || MechanicalPistonBlock.isPistonHead(nextBlock) && nextBlock.func_177229_b((Property)BlockStateProperties.field_208155_H) == direction) {
                actualStart = actualStart.func_177972_a(direction);
                poles.add(new Template.BlockInfo(actualStart, (BlockState)nextBlock.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction), null));
                ++extensionsInFront;
                if (MechanicalPistonBlock.isPistonHead(nextBlock)) break;
                nextBlock = world.func_180495_p(actualStart.func_177972_a(direction));
                if (extensionsInFront <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
                throw AssemblyException.tooManyPistonPoles();
            }
        }
        if (extensionsInFront == 0) {
            poles.add(new Template.BlockInfo(pos, (BlockState)((BlockState)AllBlocks.MECHANICAL_PISTON_HEAD.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction)).func_206870_a((Property)BlockStateProperties.field_208144_as, (Comparable)(sticky ? PistonType.STICKY : PistonType.DEFAULT)), null));
        } else {
            poles.add(new Template.BlockInfo(pos, (BlockState)AllBlocks.PISTON_EXTENSION_POLE.getDefaultState().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction), null));
        }
        BlockPos end = pos;
        nextBlock = world.func_180495_p(end.func_177972_a(direction.func_176734_d()));
        int extensionsInBack = 0;
        while (PistonExtensionPoleBlock.PlacementHelper.get().matchesAxis(nextBlock, direction.func_176740_k())) {
            end = end.func_177972_a(direction.func_176734_d());
            poles.add(new Template.BlockInfo(end, (BlockState)nextBlock.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction), null));
            nextBlock = world.func_180495_p(end.func_177972_a(direction.func_176734_d()));
            if (extensionsInFront + ++extensionsInBack <= MechanicalPistonBlock.maxAllowedPistonPoles()) continue;
            throw AssemblyException.tooManyPistonPoles();
        }
        this.anchor = pos.func_177967_a(direction, this.initialExtensionProgress + 1);
        this.extensionLength = extensionsInBack + extensionsInFront;
        this.initialExtensionProgress = extensionsInFront;
        this.pistonExtensionCollisionBox = new AxisAlignedBB(BlockPos.field_177992_a.func_177967_a(direction, -1), BlockPos.field_177992_a.func_177967_a(direction, -this.extensionLength - 1)).func_72321_a(1.0, 1.0, 1.0);
        if (this.extensionLength == 0) {
            throw AssemblyException.noPistonPoles();
        }
        this.bounds = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (Template.BlockInfo pole : poles) {
            BlockPos relPos = pole.field_186242_a.func_177967_a(direction, -extensionsInFront);
            BlockPos localPos = relPos.func_177973_b((Vector3i)this.anchor);
            this.getBlocks().put(localPos, new Template.BlockInfo(localPos, pole.field_186243_b, null));
        }
        return true;
    }

    @Override
    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return this.pistonExtensionCollisionBox.func_72318_a(VecHelper.getCenterOf((Vector3i)pos.func_177973_b((Vector3i)this.anchor)));
    }

    @Override
    protected boolean addToInitialFrontier(World world, BlockPos pos, Direction direction, Queue<BlockPos> frontier) throws AssemblyException {
        boolean retracting;
        frontier.clear();
        boolean sticky = MechanicalPistonBlock.isStickyPiston(world.func_180495_p(pos.func_177967_a(this.orientation, -1)));
        boolean bl = retracting = direction != this.orientation;
        if (retracting && !sticky) {
            return true;
        }
        for (int offset = 0; offset <= (Integer)AllConfigs.SERVER.kinetics.maxChassisRange.get(); ++offset) {
            if (offset == 1 && retracting) {
                return true;
            }
            BlockPos currentPos = pos.func_177967_a(this.orientation, offset + this.initialExtensionProgress);
            if (retracting && World.func_189509_E((BlockPos)currentPos)) {
                return true;
            }
            if (!world.func_195588_v(currentPos)) {
                throw AssemblyException.unloadedChunk(currentPos);
            }
            BlockState state = world.func_180495_p(currentPos);
            if (!BlockMovementChecks.isMovementNecessary(state, world, currentPos)) {
                return true;
            }
            if (BlockMovementChecks.isBrittle(state) && !(state.func_177230_c() instanceof CarpetBlock)) {
                return true;
            }
            if (MechanicalPistonBlock.isPistonHead(state) && state.func_177229_b((Property)BlockStateProperties.field_208155_H) == direction.func_176734_d()) {
                return true;
            }
            if (!BlockMovementChecks.isMovementAllowed(state, world, currentPos)) {
                if (retracting) {
                    return true;
                }
                throw AssemblyException.unmovableBlock(currentPos, state);
            }
            if (retracting && state.func_185905_o() == PushReaction.PUSH_ONLY) {
                return true;
            }
            frontier.add(currentPos);
            if (!BlockMovementChecks.isNotSupportive(state, this.orientation)) continue;
            return true;
        }
        return true;
    }

    @Override
    public void addBlock(BlockPos pos, Pair<Template.BlockInfo, TileEntity> capture) {
        super.addBlock(pos.func_177967_a(this.orientation, -this.initialExtensionProgress), capture);
    }

    @Override
    public BlockPos toLocalPos(BlockPos globalPos) {
        return globalPos.func_177973_b((Vector3i)this.anchor).func_177967_a(this.orientation, -this.initialExtensionProgress);
    }

    @Override
    protected boolean customBlockPlacement(IWorld world, BlockPos pos, BlockState state) {
        BlockPos pistonPos = this.anchor.func_177967_a(this.orientation, -1);
        BlockState pistonState = world.func_180495_p(pistonPos);
        TileEntity te = world.func_175625_s(pistonPos);
        if (pos.equals((Object)pistonPos)) {
            if (te == null || te.func_145837_r()) {
                return true;
            }
            if (!MechanicalPistonBlock.isExtensionPole(state) && MechanicalPistonBlock.isPiston(pistonState)) {
                world.func_180501_a(pistonPos, (BlockState)pistonState.func_206870_a(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.RETRACTED)), 19);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean customBlockRemoval(IWorld world, BlockPos pos, BlockState state) {
        BlockPos pistonPos = this.anchor.func_177967_a(this.orientation, -1);
        BlockState blockState = world.func_180495_p(pos);
        if (pos.equals((Object)pistonPos) && MechanicalPistonBlock.isPiston(blockState)) {
            world.func_180501_a(pos, (BlockState)blockState.func_206870_a(MechanicalPistonBlock.STATE, (Comparable)((Object)MechanicalPistonBlock.PistonState.MOVING)), 82);
            return true;
        }
        return false;
    }

    @Override
    public void readNBT(World world, CompoundNBT nbt, boolean spawnData) {
        super.readNBT(world, nbt, spawnData);
        this.initialExtensionProgress = nbt.func_74762_e("InitialLength");
        this.extensionLength = nbt.func_74762_e("ExtensionLength");
        this.orientation = Direction.func_82600_a((int)nbt.func_74762_e("Orientation"));
    }

    @Override
    public CompoundNBT writeNBT(boolean spawnPacket) {
        CompoundNBT tag = super.writeNBT(spawnPacket);
        tag.func_74768_a("InitialLength", this.initialExtensionProgress);
        tag.func_74768_a("ExtensionLength", this.extensionLength);
        tag.func_74768_a("Orientation", this.orientation.func_176745_a());
        return tag;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new PistonLighter(this);
    }
}

