/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;

public class ContraptionMatrices {
    private final MatrixStack modelViewProjection = new MatrixStack();
    private final MatrixStack viewProjection = new MatrixStack();
    private final MatrixStack model = new MatrixStack();
    private final Matrix4f world = new Matrix4f();
    private final Matrix4f light = new Matrix4f();
    private boolean ready;

    public ContraptionMatrices() {
        this.world.func_226591_a_();
        this.light.func_226591_a_();
    }

    public void setup(MatrixStack viewProjection, AbstractContraptionEntity entity) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        this.viewProjection.func_227860_a_();
        ContraptionMatrices.transform(this.viewProjection, viewProjection);
        this.model.func_227860_a_();
        entity.doLocalTransforms(partialTicks, new MatrixStack[]{this.model});
        this.modelViewProjection.func_227860_a_();
        ContraptionMatrices.transform(this.modelViewProjection, viewProjection);
        ContraptionMatrices.transform(this.modelViewProjection, this.model);
        ContraptionMatrices.translateToEntity(this.world, entity, partialTicks);
        this.light.set(this.world);
        this.light.func_226595_a_(this.model.func_227866_c_().func_227870_a_());
        this.ready = true;
    }

    public void clear() {
        ContraptionMatrices.clearStack(this.modelViewProjection);
        ContraptionMatrices.clearStack(this.viewProjection);
        ContraptionMatrices.clearStack(this.model);
        this.world.func_226591_a_();
        this.light.func_226591_a_();
        this.ready = false;
    }

    public MatrixStack getModelViewProjection() {
        return this.modelViewProjection;
    }

    public MatrixStack getViewProjection() {
        return this.viewProjection;
    }

    public MatrixStack getModel() {
        return this.model;
    }

    public Matrix4f getWorld() {
        return this.world;
    }

    public Matrix4f getLight() {
        return this.light;
    }

    public boolean isReady() {
        return this.ready;
    }

    public static void transform(MatrixStack ms, MatrixStack transform) {
        ms.func_227866_c_().func_227870_a_().func_226595_a_(transform.func_227866_c_().func_227870_a_());
        ms.func_227866_c_().func_227872_b_().func_226118_b_(transform.func_227866_c_().func_227872_b_());
    }

    public static void translateToEntity(Matrix4f matrix, Entity entity, float partialTicks) {
        double x = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70142_S, (double)entity.func_226277_ct_());
        double y = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70137_T, (double)entity.func_226278_cu_());
        double z = MathHelper.func_219803_d((double)partialTicks, (double)entity.field_70136_U, (double)entity.func_226281_cx_());
        matrix.setTranslation((float)x, (float)y, (float)z);
    }

    public static void clearStack(MatrixStack ms) {
        while (!ms.func_227867_d_()) {
            ms.func_227865_b_();
        }
    }
}

