/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlockItem;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlazeBurnerBlock
extends Block
implements ITE<BlazeBurnerTileEntity> {
    public static final EnumProperty<HeatLevel> HEAT_LEVEL = EnumProperty.func_177709_a((String)"blaze", HeatLevel.class);

    public BlazeBurnerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(HEAT_LEVEL, (Comparable)((Object)HeatLevel.NONE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HEAT_LEVEL});
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos.func_177984_a());
        if (!(tileEntity instanceof BasinTileEntity)) {
            return;
        }
        BasinTileEntity basin = (BasinTileEntity)tileEntity;
        basin.notifyChangeOfContents();
    }

    public boolean hasTileEntity(BlockState state) {
        return ((HeatLevel)((Object)state.func_177229_b(HEAT_LEVEL))).isAtLeast(HeatLevel.SMOULDERING);
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> list) {
        list.add((Object)AllItems.EMPTY_BLAZE_BURNER.asStack());
        super.func_149666_a(group, list);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.HEATER.create();
    }

    @Override
    public Class<BlazeBurnerTileEntity> getTileEntityClass() {
        return BlazeBurnerTileEntity.class;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!state.hasTileEntity()) {
            if (heldItem.func_77973_b() instanceof FlintAndSteelItem) {
                world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                heldItem.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                world.func_175656_a(pos, AllBlocks.LIT_BLAZE_BURNER.getDefaultState());
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
        boolean doNotConsume = player.func_184812_l_();
        boolean forceOverflow = !(player instanceof FakePlayer);
        ActionResult<ItemStack> res = BlazeBurnerBlock.tryInsert(state, world, pos, heldItem, doNotConsume, forceOverflow, false);
        ItemStack leftover = (ItemStack)res.func_188398_b();
        if (!(world.field_72995_K || doNotConsume || leftover.func_190926_b())) {
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, leftover);
            } else if (!player.field_71071_by.func_70441_a(leftover)) {
                player.func_71019_a(leftover, false);
            }
        }
        return res.func_188397_a() == ActionResultType.SUCCESS ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public static ActionResult<ItemStack> tryInsert(BlockState state, World world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceOverflow, boolean simulate) {
        if (!state.hasTileEntity()) {
            return ActionResult.func_226251_d_((Object)ItemStack.field_190927_a);
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BlazeBurnerTileEntity)) {
            return ActionResult.func_226251_d_((Object)ItemStack.field_190927_a);
        }
        BlazeBurnerTileEntity burnerTE = (BlazeBurnerTileEntity)te;
        if (burnerTE.isCreativeFuel(stack)) {
            if (!simulate) {
                burnerTE.applyCreativeFuel();
            }
            return ActionResult.func_226248_a_((Object)ItemStack.field_190927_a);
        }
        if (!burnerTE.tryUpdateFuel(stack, forceOverflow, simulate)) {
            return ActionResult.func_226251_d_((Object)ItemStack.field_190927_a);
        }
        if (!doNotConsume) {
            ItemStack container = stack.getContainerItem();
            if (!world.field_72995_K && !simulate) {
                stack.func_190918_g(1);
            }
            if (!container.func_190926_b()) {
                return ActionResult.func_226248_a_((Object)container);
            }
        }
        return ActionResult.func_226248_a_((Object)ItemStack.field_190927_a);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        Item item = stack.func_77973_b();
        BlockState defaultState = this.func_176223_P();
        if (!(item instanceof BlazeBurnerBlockItem)) {
            return defaultState;
        }
        HeatLevel initialHeat = ((BlazeBurnerBlockItem)item).hasCapturedBlaze() ? HeatLevel.SMOULDERING : HeatLevel.NONE;
        return (BlockState)defaultState.func_206870_a(HEAT_LEVEL, (Comparable)((Object)initialHeat));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState p_220071_1_, IBlockReader p_220071_2_, BlockPos p_220071_3_, ISelectionContext p_220071_4_) {
        if (p_220071_4_ == ISelectionContext.func_216377_a()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.func_220053_a(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean func_149740_M(BlockState p_149740_1_) {
        return true;
    }

    public int func_180641_l(BlockState state, World p_180641_2_, BlockPos p_180641_3_) {
        return Math.max(0, ((HeatLevel)((Object)state.func_177229_b(HEAT_LEVEL))).ordinal() - 1);
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (!((HeatLevel)((Object)state.func_177229_b(HEAT_LEVEL))).isAtLeast(HeatLevel.SMOULDERING)) {
            return;
        }
        world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }

    public static HeatLevel getHeatLevelOf(BlockState blockState) {
        return blockState.func_235901_b_(HEAT_LEVEL) ? (HeatLevel)((Object)blockState.func_177229_b(HEAT_LEVEL)) : HeatLevel.NONE;
    }

    public static int getLight(BlockState state) {
        return MathHelper.func_76125_a((int)(((HeatLevel)((Object)state.func_177229_b(HEAT_LEVEL))).ordinal() * 4 - 1), (int)0, (int)15);
    }

    public static LootTable.Builder buildLootTable() {
        ILootCondition.IBuilder survivesExplosion = SurvivesExplosion.func_215968_b();
        BlazeBurnerBlock block = (BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get();
        LootTable.Builder builder = LootTable.func_216119_b();
        LootPool.Builder poolBuilder = LootPool.func_216096_a();
        for (HeatLevel level : HeatLevel.values()) {
            IItemProvider drop = level == HeatLevel.NONE ? (IItemProvider)AllItems.EMPTY_BLAZE_BURNER.get() : (IItemProvider)AllBlocks.BLAZE_BURNER.get();
            poolBuilder.func_216045_a(((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)drop).func_212840_b_(survivesExplosion)).func_212840_b_((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227193_a_(HEAT_LEVEL, (Comparable)((Object)level)))));
        }
        builder.func_216040_a(poolBuilder.func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)));
        return builder;
    }

    public static enum HeatLevel implements IStringSerializable
    {
        NONE,
        SMOULDERING,
        FADING,
        KINDLED,
        SEETHING;


        public static HeatLevel byIndex(int index) {
            return HeatLevel.values()[index];
        }

        public HeatLevel nextActiveLevel() {
            return HeatLevel.byIndex(this.ordinal() % (HeatLevel.values().length - 1) + 1);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public String func_176610_l() {
            return Lang.asId(this.name());
        }
    }
}

