/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.curiosities.bell.AbstractBellTileEntity;
import com.simibubi.create.content.curiosities.bell.HauntedBellPulser;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HauntedBellTileEntity
extends AbstractBellTileEntity {
    public static final int DISTANCE = 10;
    public static final int RECHARGE_TICKS = 65;
    public static final int EFFECT_TICKS = 20;
    public int effectTicks = 0;

    public HauntedBellTileEntity(TileEntityType<?> type) {
        super(type);
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public PartialModel getBellModel() {
        return AllBlockPartials.HAUNTED_BELL;
    }

    @Override
    public boolean ring(World world, BlockPos pos, Direction direction) {
        if (this.isRinging && this.ringingTicks < 65) {
            return false;
        }
        if (!super.ring(world, pos, direction)) {
            return false;
        }
        if (!world.field_72995_K) {
            HauntedBellPulser.sendPulse(world, pos, 10, false);
        }
        this.startEffect();
        return true;
    }

    public void startEffect() {
        this.effectTicks = 20;
        this.sendData();
    }

    @Override
    protected void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.func_74768_a("EffectTicks", this.effectTicks);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.effectTicks = compound.func_74762_e("EffectTicks");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.effectTicks <= 0) {
            return;
        }
        --this.effectTicks;
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        Random rand = this.field_145850_b.func_201674_k();
        if (rand.nextFloat() > 0.25f) {
            return;
        }
        this.spawnParticle(rand);
        this.playSound(rand);
    }

    protected void spawnParticle(Random rand) {
        double x = (double)this.field_174879_c.func_177958_n() + rand.nextDouble();
        double y = (double)this.field_174879_c.func_177956_o() + 0.5;
        double z = (double)this.field_174879_c.func_177952_p() + rand.nextDouble();
        double vx = rand.nextDouble() * 0.04 - 0.02;
        double vy = 0.1;
        double vz = rand.nextDouble() * 0.04 - 0.02;
        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, x, y, z, vx, vy, vz);
    }

    protected void playSound(Random rand) {
        float vol = rand.nextFloat() * 0.4f + rand.nextFloat() > 0.9f ? 0.6f : 0.0f;
        float pitch = 0.6f + rand.nextFloat() * 0.4f;
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_232831_nS_, SoundCategory.BLOCKS, vol, pitch);
    }
}

