/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.block.ITE;
import java.util.Optional;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkHooks;

public class ToolboxBlock
extends HorizontalBlock
implements IWaterLoggable,
ITE<ToolboxTileEntity> {
    private final DyeColor color;

    public ToolboxBlock(AbstractBlock.Properties p_i48440_1_, DyeColor color) {
        super(p_i48440_1_);
        this.color = color;
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> p_149666_2_) {
        if (group != ItemGroup.field_78027_g && this.color != DyeColor.BROWN) {
            return;
        }
        super.func_149666_a(group, p_149666_2_);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y}).func_206894_a(new Property[]{field_185512_D}));
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.field_72995_K) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> {
            te.readInventory(stack.func_196082_o().func_74775_l("Inventory"));
            if (stack.func_82837_s()) {
                te.setCustomName(stack.func_200301_q());
            }
        });
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean moving) {
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            world.func_175713_t(pos);
        }
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        this.withTileEntityDo((IBlockReader)world, pos, ToolboxTileEntity::unequipTracked);
        if (world instanceof ServerWorld) {
            ItemStack cloneItemStack = this.func_185473_a((IBlockReader)world, pos, state);
            world.func_175655_b(pos, false);
            if (world.func_180495_p(pos) != state) {
                player.field_71071_by.func_191975_a(world, cloneItemStack);
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((IItemProvider)this);
        Optional tileEntityOptional = this.getTileEntityOptional(world, pos);
        CompoundNBT tag = item.func_196082_o();
        CompoundNBT inv = tileEntityOptional.map(tb -> tb.inventory.serializeNBT()).orElse(new CompoundNBT());
        tag.func_218657_a("Inventory", (INBT)inv);
        ITextComponent customName = tileEntityOptional.map(ToolboxTileEntity::func_200201_e).orElse(null);
        if (customName != null) {
            item.func_200302_a(customName);
        }
        return item;
    }

    public BlockState func_196271_a(BlockState state, Direction direction, BlockState neighbourState, IWorld world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return state;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return AllShapes.TOOLBOX.get((Direction)state.func_177229_b((Property)field_185512_D));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (player == null || player.func_213453_ef()) {
            return ActionResultType.PASS;
        }
        if (player instanceof FakePlayer) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        this.withTileEntityDo((IBlockReader)world, pos, toolbox -> NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)toolbox, toolbox::sendToContainer));
        return ActionResultType.SUCCESS;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return AllTileEntities.TOOLBOX.create();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    @Override
    public Class<ToolboxTileEntity> getTileEntityClass() {
        return ToolboxTileEntity.class;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public static Ingredient getMainBox() {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)AllBlocks.TOOLBOXES.get(DyeColor.BROWN).get()});
    }
}

