/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.simibubi.create.AllContainerTypes;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxSlot;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.ContainerBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ToolboxContainer
extends ContainerBase<ToolboxTileEntity> {
    public boolean renderPass;

    public static ToolboxContainer create(int id, PlayerInventory inv, ToolboxTileEntity te) {
        return new ToolboxContainer((ContainerType)AllContainerTypes.TOOLBOX.get(), id, inv, te);
    }

    public ToolboxContainer(ContainerType<?> type, int id, PlayerInventory inv, PacketBuffer extraData) {
        super(type, id, inv, extraData);
    }

    public ToolboxContainer(ContainerType<?> type, int id, PlayerInventory inv, ToolboxTileEntity te) {
        super(type, id, inv, te);
        te.startOpen(this.player);
    }

    @Override
    protected ToolboxTileEntity createOnClient(PacketBuffer extraData) {
        BlockPos readBlockPos = extraData.func_179259_c();
        CompoundNBT readNbt = extraData.func_150793_b();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        TileEntity tileEntity = world.func_175625_s(readBlockPos);
        if (tileEntity instanceof ToolboxTileEntity) {
            ToolboxTileEntity toolbox = (ToolboxTileEntity)tileEntity;
            toolbox.handleUpdateTag(toolbox.func_195044_w(), readNbt);
            return toolbox;
        }
        return null;
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot clickedSlot = this.func_75139_a(index);
        if (!clickedSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = clickedSlot.func_75211_c();
        int size = ((ToolboxTileEntity)this.contentHolder).inventory.getSlots();
        if (index < size) {
            this.func_75135_a(stack, size, this.field_75151_b.size(), false);
            ((ToolboxTileEntity)this.contentHolder).inventory.onContentsChanged(index);
        } else {
            this.func_75135_a(stack, 0, size - 1, false);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected void initAndReadInventory(ToolboxTileEntity contentHolder) {
    }

    public ItemStack func_184996_a(int index, int flags, ClickType type, PlayerEntity player) {
        int size = ((ToolboxTileEntity)this.contentHolder).inventory.getSlots();
        if (index >= 0 && index < size) {
            int subIndex;
            ItemStack itemInClickedSlot = this.func_75139_a(index).func_75211_c();
            PlayerInventory playerInv = player.field_71071_by;
            ItemStack carried = playerInv.func_70445_o();
            if (type == ClickType.PICKUP && !carried.func_190926_b() && !itemInClickedSlot.func_190926_b() && ToolboxInventory.canItemsShareCompartment(itemInClickedSlot, carried) && (subIndex = index % 4) != 3) {
                return this.func_184996_a(index - subIndex + 4 - 1, flags, type, player);
            }
            if (type == ClickType.PICKUP && carried.func_190926_b() && itemInClickedSlot.func_190926_b() && !player.field_70170_p.field_72995_K) {
                ((ToolboxTileEntity)this.contentHolder).inventory.filters.set(index / 4, ItemStack.field_190927_a);
                ((ToolboxTileEntity)this.contentHolder).sendData();
            }
        }
        return super.func_184996_a(index, flags, type, player);
    }

    public boolean func_94531_b(Slot slot) {
        return slot.field_75222_d > ((ToolboxTileEntity)this.contentHolder).inventory.getSlots() && super.func_94531_b(slot);
    }

    public ItemStack getFilter(int compartment) {
        return ((ToolboxTileEntity)this.contentHolder).inventory.filters.get(compartment);
    }

    public int totalCountInCompartment(int compartment) {
        int count = 0;
        int baseSlot = compartment * 4;
        for (int i = 0; i < 4; ++i) {
            count += this.func_75139_a(baseSlot + i).func_75211_c().func_190916_E();
        }
        return count;
    }

    @Override
    protected void addSlots() {
        ToolboxInventory inventory = ((ToolboxTileEntity)this.contentHolder).inventory;
        int x = 59;
        int y = 37;
        int[] xOffsets = new int[]{x, x + 33, x + 66, x + 66 + 6, x + 66, x + 33, x, x - 6};
        int[] yOffsets = new int[]{y, y - 6, y, y + 33, y + 66, y + 66 + 6, y + 66, y + 33};
        for (int compartment = 0; compartment < 8; ++compartment) {
            int baseIndex = compartment * 4;
            this.func_75146_a((Slot)new ToolboxSlot(this, (IItemHandler)inventory, baseIndex, xOffsets[compartment], yOffsets[compartment]));
            for (int i = 1; i < 4; ++i) {
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)inventory, baseIndex + i, -100, -100));
            }
        }
        this.addPlayerSlots(-12, 166);
    }

    @Override
    protected void saveData(ToolboxTileEntity contentHolder) {
    }

    @Override
    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        if (!playerIn.field_70170_p.field_72995_K) {
            ((ToolboxTileEntity)this.contentHolder).stopOpen(playerIn);
        }
    }
}

